/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.clowder;

import com.hfr.clowder.Clowder;
import com.hfr.data.ClowderData;
import com.hfr.main.MainRegistry;
import com.hfr.tileentity.clowder.ITerritoryProvider;
import com.hfr.tileentity.clowder.TileEntityConquerer;
import com.hfr.tileentity.clowder.TileEntityFlag;
import com.hfr.tileentity.clowder.TileEntityFlagBig;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ClowderTerritory {
    public static final Ownership SAFEZONE = new Ownership(Zone.SAFEZONE);
    public static final Ownership WARZONE = new Ownership(Zone.WARZONE);
    public static final Ownership WILDERNESS = new Ownership(Zone.WILDERNESS);
    public static final int SAFEZONE_COLOR = 0xFF8000;
    public static final int WARZONE_COLOR = 0xFF0000;
    public static final int WILDERNESS_COLOR = 0xFFFFFF;
    public static HashMap<Long, TerritoryMeta> territories = new HashMap();
    private static final int cycle = MainRegistry.territoryAmount;
    private static int ptr = 0;

    public static CoordPair getCoordPair(int x, int z) {
        return new CoordPair(++x / 16, ++z / 16);
    }

    public static void setOwnerForCoord(World world, CoordPair coords, Clowder owner, int fX, int fY, int fZ, String name) {
        ClowderTerritory.setOwnerForInts(world, coords.x, coords.z, owner, fX, fY, fZ, name);
    }

    public static void setOwnerForInts(World world, int x, int z, Clowder owner, int fX, int fY, int fZ, String name) {
        long code = ClowderTerritory.intsToCode(x, z);
        territories.remove(code);
        Ownership o = new Ownership(Zone.FACTION, owner);
        TerritoryMeta metadata = new TerritoryMeta(o, fX, fY, fZ);
        metadata.name = name;
        TileEntity flag = world.func_147438_o(fX, fY, fZ);
        if (flag != null) {
            if (flag instanceof TileEntityFlagBig) {
                ((TileEntityFlagBig)flag).provinceName = name;
            } else if (flag instanceof TileEntityConquerer) {
                ((TileEntityConquerer)flag).name = name;
            }
        }
        territories.put(code, metadata);
        ClowderData.getData(world).func_76185_a();
    }

    public static void setZoneForCoord(World world, CoordPair coords, Zone zone) {
        ClowderTerritory.setZoneForInts(world, coords.x, coords.z, zone);
    }

    public static void setZoneForInts(World world, int x, int z, Zone zone) {
        long code = ClowderTerritory.intsToCode(x, z);
        territories.remove(code);
        if (zone != Zone.WILDERNESS) {
            Ownership o = new Ownership(zone, null);
            TerritoryMeta metadata = new TerritoryMeta(o);
            territories.put(code, metadata);
        }
        ClowderData.getData(world).func_76185_a();
    }

    public static void removeZoneForCoord(World world, CoordPair coords) {
        ClowderTerritory.removeZoneForInts(world, coords.x, coords.z);
    }

    public static void removeZoneForInts(World world, int x, int z) {
        long code = ClowderTerritory.intsToCode(x, z);
        territories.remove(code);
        ClowderData.getData(world).func_76185_a();
    }

    public static Ownership getOwnerFromCoords(CoordPair coords) {
        return ClowderTerritory.getOwner(coords.x, coords.z);
    }

    public static Ownership getOwnerFromInts(int x, int z) {
        return ClowderTerritory.getOwner(x / 16, ++z / 16);
    }

    public static Ownership getOwner(int x, int z) {
        long code = ClowderTerritory.intsToCode(x, z);
        TerritoryMeta meta = territories.get(code);
        if (meta == null) {
            return WILDERNESS;
        }
        Ownership owner = meta.owner;
        if (owner.zone == Zone.FACTION && owner.owner == null) {
            return WILDERNESS;
        }
        return owner == null ? WILDERNESS : owner;
    }

    public static boolean isPlayerHome(EntityPlayer player) {
        Clowder clowder = Clowder.getClowderFromPlayer(player);
        if (clowder == null) {
            return false;
        }
        Ownership owner = ClowderTerritory.getOwnerFromInts((int)player.field_70165_t, (int)player.field_70161_v);
        return owner != null && owner.zone == Zone.FACTION && owner.owner == clowder;
    }

    public static TerritoryMeta getMetaFromIntCoords(int x, int z) {
        return ClowderTerritory.getMetaFromInts(x / 16, ++z / 16);
    }

    public static TerritoryMeta getMetaFromCoords(CoordPair coords) {
        return ClowderTerritory.getMetaFromInts(coords.x, coords.z);
    }

    public static TerritoryMeta getMetaFromInts(int x, int z) {
        long code = ClowderTerritory.intsToCode(x, z);
        TerritoryMeta meta = territories.get(code);
        if (meta != null && meta.owner.zone == Zone.FACTION && meta.owner.owner == null) {
            meta.owner = WILDERNESS;
        }
        if (meta != null && meta.owner == WILDERNESS) {
            return null;
        }
        return meta;
    }

    public static CoordPair codeToCoords(long code) {
        return new CoordPair((int)(code >> 32), (int)code);
    }

    public static long coordsToCode(CoordPair coord) {
        try {
            return ClowderTerritory.intsToCode(coord.x, coord.z);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long intsToCode(int x, int z) {
        return ((long)x & 0xFFFFFFFFL) << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static void checkPersistence(World world, int cycle, int index) {
        ArrayList<Long> BOW = new ArrayList<Long>(territories.keySet());
        for (int i = index; i < BOW.size(); i += cycle) {
            long code = (Long)BOW.get(i);
            TerritoryMeta meta = territories.get(code);
            if (meta != null) {
                if (meta.checkPersistence(world, ClowderTerritory.codeToCoords(code))) continue;
                territories.remove(code);
                --i;
                continue;
            }
            territories.remove(code);
            --i;
        }
    }

    public static void persistenceAutomaton(World world) {
        ++ptr;
        ClowderTerritory.checkPersistence(world, cycle, ptr %= cycle);
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        territories.clear();
        int count = nbt.func_74762_e("territory_count");
        for (int i = 0; i < count; ++i) {
            long code = nbt.func_74763_f("code_" + i);
            TerritoryMeta meta = TerritoryMeta.readFromNBT(nbt, "meta_" + i);
            if (meta == null || meta.owner.zone == Zone.WILDERNESS) continue;
            territories.put(code, meta);
        }
    }

    public static void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("territory_count", territories.size());
        int index = 0;
        for (long code : territories.keySet()) {
            TerritoryMeta meta = territories.get(code);
            if (meta.owner.zone != Zone.WILDERNESS) {
                nbt.func_74772_a("code_" + index, code);
                meta.writeToNBT(nbt, "meta_" + index);
            }
            ++index;
        }
    }

    public static class TerritoryMeta {
        public Ownership owner;
        public int flagX;
        public int flagY;
        public int flagZ;
        public String name;

        public TerritoryMeta(Ownership owner, int flagX, int flagY, int flagZ) {
            this.owner = owner;
            this.flagX = flagX;
            this.flagY = flagY;
            this.flagZ = flagZ;
            this.name = "";
        }

        public TerritoryMeta(Ownership owner, int flagX, int flagY, int flagZ, World world, String name) {
            this.owner = owner;
            this.flagX = flagX;
            this.flagY = flagY;
            this.flagZ = flagZ;
            TileEntityFlagBig flag = (TileEntityFlagBig)world.func_147438_o(flagX, flagY, flagZ);
            if (flag != null) {
                flag.provinceName = name;
            }
        }

        public TerritoryMeta(Ownership owner) {
            this(owner, -1, -1, -1);
        }

        public void writeToNBT(NBTTagCompound nbt, String code) {
            this.owner.writeToNBT(nbt, code);
            nbt.func_74768_a(code + "X", this.flagX);
            nbt.func_74768_a(code + "Y", this.flagY);
            nbt.func_74768_a(code + "Z", this.flagZ);
            nbt.func_74778_a("name_" + code, this.name);
        }

        public static TerritoryMeta readFromNBT(NBTTagCompound nbt, String code) {
            TerritoryMeta meta = new TerritoryMeta(Ownership.readFromNBT(nbt, code), nbt.func_74762_e(code + "X"), nbt.func_74762_e(code + "Y"), nbt.func_74762_e(code + "Z"));
            return meta;
        }

        public int getColor() {
            if (this.owner != null) {
                return this.owner.getColor();
            }
            return 0;
        }

        public boolean checkPersistence(World world, CoordPair claim) {
            if (this.owner.zone != Zone.FACTION) {
                return true;
            }
            if (this.flagY < 0) {
                return false;
            }
            Clowder own = this.owner.owner;
            CoordPair origin = ClowderTerritory.getCoordPair(this.flagX, this.flagZ);
            if (world == null || world.func_72863_F() == null) {
                return true;
            }
            Chunk chunk = world.func_72863_F().func_73154_d(this.flagX >> 4, this.flagZ >> 4);
            if (chunk != null) {
                TileEntity te = world.func_147438_o(this.flagX, this.flagY, this.flagZ);
                if (te instanceof ITerritoryProvider) {
                    ITerritoryProvider flag = (ITerritoryProvider)te;
                    int r = flag.getRadius();
                    this.name = flag.getClaimName();
                    double dist = Math.sqrt(Math.pow(origin.x - claim.x, 2.0) + Math.pow(origin.z - claim.z, 2.0));
                    if (flag.getOwner() != own) {
                        return false;
                    }
                    if (dist >= (double)r) {
                        if (flag instanceof TileEntityFlag && ((TileEntityFlag)flag).height > 0.0f && ((TileEntityFlag)flag).height < 1.0f) {
                            return true;
                        }
                        return flag instanceof TileEntityConquerer && ((TileEntityConquerer)flag).height > 0.0f;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public static class CoordPair {
        public int x;
        public int z;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            result = 31 * result + this.z;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoordPair other = (CoordPair)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.z == other.z;
        }

        public CoordPair(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }

    public static enum Zone {
        SAFEZONE,
        WARZONE,
        WILDERNESS,
        FACTION;

    }

    public static class Ownership {
        public Zone zone;
        public Clowder owner;

        public Ownership(Zone zone, Clowder owner) {
            this.zone = zone;
            if (zone == Zone.FACTION) {
                this.owner = owner;
            }
        }

        public Ownership(Zone zone) {
            this.zone = zone;
        }

        public void writeToNBT(NBTTagCompound nbt, String code) {
            if (this.zone == Zone.FACTION && this.owner == null) {
                return;
            }
            nbt.func_74768_a("ownership_" + code + "_zone", this.zone.ordinal());
            if (this.zone == Zone.FACTION) {
                nbt.func_74778_a("ownership_" + code + "_owner", this.owner.name);
            }
        }

        public static Ownership readFromNBT(NBTTagCompound nbt, String code) {
            Zone zone = Zone.values()[nbt.func_74762_e("ownership_" + code + "_zone")];
            Clowder clowder = null;
            if (zone == Zone.FACTION) {
                clowder = Clowder.getClowderFromName(nbt.func_74779_i("ownership_" + code + "_owner"));
            }
            if (zone == Zone.FACTION && clowder == null) {
                return WILDERNESS;
            }
            Ownership ownership = new Ownership(zone, clowder);
            return ownership;
        }

        public int getColor() {
            switch (this.zone) {
                case FACTION: {
                    return this.owner.color;
                }
                case SAFEZONE: {
                    return 0xFF8000;
                }
                case WARZONE: {
                    return 0xFF0000;
                }
                case WILDERNESS: {
                    return 0xFFFFFF;
                }
            }
            return 0;
        }
    }
}

