/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.command;

import com.hfr.blocks.BlockDummyable;
import com.hfr.blocks.ModBlocks;
import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderFlag;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.clowder.events.RegionOwnershipChangedEvent;
import com.hfr.data.ClowderData;
import com.hfr.items.ModItems;
import com.hfr.main.MainRegistry;
import com.hfr.packet.PacketDispatcher;
import com.hfr.packet.effect.ClowderFlagPacket;
import com.hfr.tileentity.clowder.ITerritoryProvider;
import com.hfr.tileentity.clowder.TileEntityFlagBig;
import com.hfr.tileentity.prop.TileEntityProp;
import com.hfr.util.ParserUtil;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class CommandClowder
extends CommandBase {
    public static final String ERROR = EnumChatFormatting.RED.toString();
    public static final String CRITICAL = EnumChatFormatting.DARK_RED.toString();
    public static final String TITLE = EnumChatFormatting.GOLD.toString();
    public static final String LIST = EnumChatFormatting.BLUE.toString();
    public static final String HELP = EnumChatFormatting.DARK_GREEN.toString();
    public static final String INFO = EnumChatFormatting.GREEN.toString();
    public static final String COMMAND = EnumChatFormatting.RED.toString();
    public static final String COMMAND_LEADER = EnumChatFormatting.DARK_RED.toString();
    public static final String COMMAND_ADMIN = EnumChatFormatting.DARK_PURPLE.toString();

    public String func_71517_b() {
        return "clowder";
    }

    public List func_71514_a() {
        return new ArrayList(){
            {
                this.add("clowder");
                this.add("c");
            }
        };
    }

    public String func_71518_a(ICommandSender sender) {
        return "/clowder help";
    }

    public boolean func_71519_b(ICommandSender p_71519_1_) {
        return true;
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (sender.func_130014_f_().field_73011_w.field_76574_g != 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(CRITICAL + "Critical error: XenoFac only works in overworld!!"));
        }
        if (Clowder.clowders.size() == 0) {
            ClowderData.getData(sender.func_130014_f_());
        }
        if (args.length < 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + this.func_71518_a(sender)));
            return;
        }
        String cmd = args[0].toLowerCase();
        if (cmd.equals("help") || cmd.equals("man")) {
            if (args.length > 1) {
                this.cmdHelp(sender, args[1]);
            } else {
                this.cmdHelp(sender, "1");
            }
            return;
        }
        if (cmd.equals("create") && args.length > 1) {
            this.cmdCreate(sender, args[1]);
            return;
        }
        if (cmd.equals("setallywarp")) {
            this.cmdSetAllyWarp(sender);
        }
        if (cmd.equals("allywarp")) {
            this.cmdAllyWarp(sender, args[1]);
        }
        if (cmd.equals("comrades")) {
            this.cmdComrades(sender);
            return;
        }
        if (cmd.equals("color") && args.length > 1) {
            this.cmdColor(sender, args[1]);
            return;
        }
        if (cmd.equals("info")) {
            if (args.length > 1) {
                this.cmdInfo(sender, args[1]);
            } else {
                this.cmdInfo(sender, null);
            }
            return;
        }
        if (cmd.equals("rename") && args.length > 1) {
            this.cmdRename(sender, args[1]);
            return;
        }
        if (cmd.equals("list")) {
            this.cmdList(sender);
            return;
        }
        if (cmd.equals("motd") && args.length > 1) {
            this.cmdMOTD(sender, args);
            return;
        }
        if (cmd.equals("owner") && args.length > 1) {
            this.cmdOwner(sender, args[1]);
            return;
        }
        if (cmd.equals("apply") && args.length > 1) {
            this.cmdApply(sender, args[1]);
            return;
        }
        if (cmd.equals("leave")) {
            this.cmdLeave(sender);
            return;
        }
        if (cmd.equals("accept") && args.length > 1) {
            this.cmdAccept(sender, args[1]);
            return;
        }
        if (cmd.equals("deny") && args.length > 1) {
            this.cmdDeny(sender, args[1]);
            return;
        }
        if (cmd.equals("applicants")) {
            this.cmdApplicants(sender);
            return;
        }
        if (cmd.equals("kick") && args.length > 1) {
            this.cmdKick(sender, args[1]);
            return;
        }
        if (cmd.equals("listflags")) {
            if (args.length > 1) {
                this.cmdListflags(sender, args[1]);
            } else {
                this.cmdListflags(sender, "1");
            }
            return;
        }
        if (cmd.equals("flag") && args.length > 1) {
            this.cmdFlag(sender, args[1]);
            return;
        }
        if (cmd.equals("retreat")) {
            this.cmdRetreat(sender);
            return;
        }
        if (cmd.equals("sethome")) {
            this.cmdSethome(sender);
            return;
        }
        if (cmd.equals("home")) {
            this.cmdHome(sender);
            return;
        }
        if ((cmd.equals("addwarp") || cmd.equals("setwarp")) && args.length > 1) {
            this.cmdAddWarp(sender, args[1]);
            return;
        }
        if (cmd.equals("delwarp") && args.length > 1) {
            this.cmdDelWarp(sender, args[1]);
            return;
        }
        if (cmd.equals("warp") && args.length > 1) {
            this.cmdWarp(sender, args[1]);
            return;
        }
        if (cmd.equals("warps")) {
            this.cmdWarps(sender);
            return;
        }
        if (cmd.equals("balance")) {
            this.cmdBalance(sender);
            return;
        }
        if (cmd.equals("deposit") && args.length > 1) {
            this.cmdDeposit(sender, args[1]);
            return;
        }
        if (cmd.equals("withdraw") && args.length > 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(CRITICAL + "This command is currently disabled!"));
            return;
        }
        if (cmd.equals("claim")) {
            this.cmdClaim(sender);
            return;
        }
        if (cmd.equals("promote") && args.length > 1) {
            this.cmdPromote(sender, args[1]);
            return;
        }
        if (cmd.equals("demote") && args.length > 1) {
            this.cmdDemote(sender, args[1]);
            return;
        }
        if (cmd.equals("nameclaim") && args.length > 1) {
            this.cmdNameClaim(sender, args[1]);
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + this.func_71518_a(sender)));
    }

    private void cmdHelp(ICommandSender sender, String page) {
        int p = CommandClowder.func_71526_a((ICommandSender)sender, (String)page);
        int pages = 4;
        if (p < 1 || p > pages) {
            p = 1;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(HELP + "/clowder [command] <args...> {optional args...}"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Commands [" + p + "/" + pages + "]:"));
        if (p == 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-help {page}" + TITLE + " - The thing you just used"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-create <name>" + TITLE + " - Creates a faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-owner <player>" + TITLE + " - Transfers faction ownership"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-comrades" + TITLE + " - Shows all members of your faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-color <hexadecimal>" + TITLE + " - Sets the faction's color"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-motd <MotD>" + TITLE + " - Sets the faction's MotD"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "/clowder help 2"));
        }
        if (p == 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-info {page}" + TITLE + " - Shows info on a faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-list" + TITLE + " - Lists all factions (page functin pending)"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-apply <name>" + TITLE + " - Sends an application to a faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-leave" + TITLE + " - Leaves the faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-accept <name>" + TITLE + " - Accepts a player's application"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-deny <name>" + TITLE + " - Denies a player's application"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-applicants" + TITLE + " - Lists applying players"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-kick <player>" + TITLE + " - Removes player from faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "/clowder help 3"));
        }
        if (p == 3) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-flag <flag>" + TITLE + " - Changes faction flag"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-listflags" + TITLE + " - Lists availible flags"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-sethome" + TITLE + " - Sets the clowder's home point"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-home" + TITLE + " - Teleports to the clowder's home"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-addwarp <name>" + TITLE + " - Creates a warp"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-delwarp <name>" + TITLE + " - Removes a warp"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-warp <name>" + TITLE + " - Teleports to a warp point"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-warps" + TITLE + " - Lists all warps"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-list" + TITLE + " - Lists all clowders (page function pending)"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "/clowder help 4"));
        }
        if (p == 4) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-retreat" + TITLE + " - Reatreats after 10 minutes"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-balance" + TITLE + " - Displays how much prestige the faction has"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-deposit <amount>" + TITLE + " - Turns prestige items into digiprestige"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-withdraw <amount>" + TITLE + " - Withdraws digiprestige as prestige items"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-promote <amount>" + TITLE + " - Promotes a member to officer"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-demote <amount>" + TITLE + " - Demotes an officer to member"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-nameclaim <name>" + TITLE + " - Renames the territory"));
        }
        if (p == 5) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-befriend <name>" + TITLE + " - Sends an alliance offer to a clowder"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-acceptfriend <playername>" + TITLE + " - Accepts a player's alliance offer and signs a treaty"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-unfriend <name>" + TITLE + " - Cancels an alliance with a clowder"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_LEADER + "-setallywarp" + TITLE + " - Sets the clowder's alliance rally-point"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-allywarp <name>" + TITLE + " - Teleports to an ally rally-point"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND + "-alliance" + TITLE + " - Shows name of all allied clowders"));
        }
    }

    private void cmdCreate(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        if (Clowder.getClowderFromPlayer((EntityPlayer)player) == null) {
            if (Clowder.getClowderFromName(name) == null) {
                Clowder.createClowder((EntityPlayer)player, name);
                sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "Created faction " + name + "!"));
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Use /c claim to get started!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This name is already taken!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can not create a new faction while already being in one!"));
        }
    }

    private void cmdDisband(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (name.equals(clowder.name)) {
                if (clowder.disbandClowder((EntityPlayer)player)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(CRITICAL + "Your faction was disbanded!"));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Can not disband a faction you do not own!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Confirmation unsuccessful. Please enter the faction name to disband the faction."));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdComrades(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + clowder.getDecoratedName()));
            for (String s : clowder.members.keySet()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + s));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdAlliance(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + clowder.getDecoratedName() + " Alliance:"));
            for (Clowder s : clowder.allies.keySet()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + s.name));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any clowder!"));
        }
    }

    private void cmdBefriend(ICommandSender sender, String name) {
        EntityPlayerMP envoy = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder diplomat = Clowder.getClowderFromPlayer((EntityPlayer)envoy);
        if (diplomat != null) {
            if (diplomat.suzerain == null) {
                if (diplomat.getPermLevel(envoy.getDisplayName()) > 1) {
                    Clowder toApply = Clowder.getClowderFromName(name);
                    if (toApply != null) {
                        if (diplomat.allies.get(toApply) == null) {
                            diplomat.notifyAll(envoy.field_70170_p, new ChatComponentText(INFO + sender.func_70005_c_() + " sent an alliance offer to " + toApply.getDecoratedName() + "!"));
                            toApply.potentialFriends.add(envoy.getDisplayName());
                            toApply.notifyAll(envoy.field_70170_p, new ChatComponentText(INFO + "Player " + sender.func_70005_c_() + " of " + diplomat.name + " wishes to form an alliance!"));
                            toApply.notifyAll(envoy.field_70170_p, new ChatComponentText(INFO + " Use /c acceptfriend " + sender.func_70005_c_() + " to accept the offer."));
                        } else {
                            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "We are already allies!"));
                        }
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "There is no clowder with this name!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions for foreign diplomacy!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Tributaries cannot form alliances!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You need to be in a clowder!"));
        }
    }

    private void cmdAcceptFriend(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.suzerain == null) {
                if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                    if (clowder.potentialFriends.contains(name)) {
                        if (Clowder.getClowderFromPlayerName(name) != null) {
                            Clowder friend = Clowder.getClowderFromPlayerName(name);
                            if (friend != clowder) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "We accepted " + name + "'s offer to make " + friend.name + " our ally!"));
                                friend.notifyAll(player.field_70170_p, new ChatComponentText(INFO + clowder.name + " accepted our offer. We are now their ally."));
                                clowder.addAlly(player.field_70170_p, friend);
                                friend.addAlly(player.field_70170_p, clowder);
                                if (clowder.enemy == friend) {
                                    clowder.pussy(player.field_70170_p);
                                    friend.notifyAll(player.field_70170_p, new ChatComponentText(INFO + "Because " + clowder.name + " accepted our alliance offer, their war goals against us were cancelled."));
                                    clowder.notifyAll(player.field_70170_p, new ChatComponentText(INFO + "Because " + friend.name + " is now our ally, our war goals against them have been cancelled."));
                                }
                            } else {
                                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "We cannot become our own ally"));
                            }
                        } else {
                            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is not in another clowder!"));
                        }
                        clowder.potentialFriends.remove(name);
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player has no active application!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to manage applications!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Tributaries cannot form alliances!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any clowder!"));
        }
    }

    private void cmdUnfriend(ICommandSender sender, String kickee) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        Clowder formerFriend = Clowder.getClowderFromName(kickee);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                if (formerFriend != null) {
                    if (clowder == formerFriend) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(CRITICAL + "You can not unfriend yourself, idiot!"));
                    } else {
                        formerFriend.notifyAll(player.field_70170_p, new ChatComponentText(INFO + clowder.name + " has cancelled our alliance!"));
                        clowder.removeAlly(player.field_70170_p, kickee);
                        formerFriend.removeAlly(player.field_70170_p, clowder.name);
                        clowder.notifyAll(player.field_70170_p, new ChatComponentText(INFO + "Friendship with " + kickee + " has ended!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This action does not exist."));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to cancel alliances!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any clowder!"));
        }
    }

    private void cmdColor(ICommandSender sender, String color) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                int c = ParserUtil.parseColor(color);
                if (c < 0) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Incorrect color format!"));
                } else {
                    clowder.setColor(c, (EntityPlayer)player);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Set faction color to " + color + "!"));
                    PacketDispatcher.wrapper.sendTo((IMessage)new ClowderFlagPacket(clowder, ""), player);
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to change this factiion's color!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdInfo(ICommandSender sender, String name) {
        Clowder clowder;
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder2 = clowder = name == null ? Clowder.getClowderFromPlayer((EntityPlayer)player) : Clowder.getClowderFromName(name);
        if (clowder != null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + clowder.getDecoratedName()));
            sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + clowder.motd));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "Owner: " + clowder.leader));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "Players considered online: " + clowder.getPlayersOnline() + "/" + clowder.members.keySet().size()));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "Raidable? " + clowder.isRaidable()));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "Members: " + clowder.members.size()));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "Prestige: " + Clowder.round(clowder.getPrestige())));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + " -generating: " + Clowder.round(clowder.getPrestigeGen()) + " per hour (x" + Clowder.round((float)Math.pow(0.99, clowder.getPrestige())) + ")"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + " -requires: " + Clowder.round(clowder.getPrestigeReq()) + " at all times"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "Color: " + Integer.toHexString(clowder.color).toUpperCase()));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdRename(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (Clowder.getClowderFromName(name) == null) {
                if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                    clowder.rename(name, (EntityPlayer)player);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "Renamed faction to " + name + "!"));
                    PacketDispatcher.wrapper.sendTo((IMessage)new ClowderFlagPacket(clowder, ""), player);
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to rename this faction!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This name is already taken!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdList(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        for (Clowder c : Clowder.clowders) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + c.getDecoratedName() + " - " + c.motd));
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + c.members.size() + " members"));
        }
        if (Clowder.clowders.isEmpty()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "There are no factions as of now. Use /clowder create <name>"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "to start your own faction!"));
        }
    }

    private void cmdMOTD(ICommandSender sender, String[] motd) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                String stitched = "";
                for (int i = 1; i < motd.length; ++i) {
                    stitched = stitched + motd[i] + " ";
                }
                stitched = stitched.trim();
                clowder.setMotd(stitched, (EntityPlayer)player);
                sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "Set faction MotD to " + stitched + "!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to change this faction's MOTD!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdOwner(ICommandSender sender, String owner) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 2) {
                if (clowder.members.get(owner) != null) {
                    clowder.transferOwnership(player.field_70170_p, owner);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Transfered leadership to player " + owner + "!"));
                    clowder.notifyLeader(player.field_70170_p, new ChatComponentText(INFO + "You are now this faction's new leader!"));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is not in your faction!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can not change the color of a faction you do not own!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdApply(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder == null) {
            Clowder toApply = Clowder.getClowderFromName(name);
            if (toApply != null) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Sent application to " + toApply.getDecoratedName() + "!"));
                toApply.applications.add(player.getDisplayName());
                toApply.notifyLeader(player.field_70170_p, new ChatComponentText(INFO + "Player " + sender.func_70005_c_() + " would like to join your faction!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "There is no faction with this name!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are already in a faction!"));
        }
    }

    private void cmdLeave(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) < 3) {
                clowder.removeMember(player.field_70170_p, player.getDisplayName());
                sender.func_145747_a((IChatComponent)new ChatComponentText(CRITICAL + "You left this faction!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can not leave a faction you own!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdAccept(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                if (clowder.applications.contains(name)) {
                    if (Clowder.getClowderFromName(name) == null) {
                        clowder.addMember(player.field_70170_p, name);
                        sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Added player " + name + " to your faction!"));
                        clowder.notifyPlayer(player.field_70170_p, name, new ChatComponentText(INFO + "You have been accepted into " + clowder.getDecoratedName() + "!"));
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is already in another faction!"));
                    }
                    clowder.applications.remove(name);
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player has no active application!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to manage applications!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdDeny(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                if (clowder.applications.contains(name)) {
                    if (Clowder.getClowderFromName(name) == null) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Denied player " + name + "'s application!"));
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is already in another faction!"));
                    }
                    clowder.applications.remove(name);
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player has no active application!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to manage applications!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdApplicants(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "Applicants:"));
                int cnt = 0;
                for (String key : clowder.applications) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "-" + key));
                    ++cnt;
                }
                if (cnt == 0) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "None!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to manage applications!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdKick(ICommandSender sender, String kickee) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                if (clowder.members.get(kickee) != null) {
                    if (player.getDisplayName().equals(kickee)) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(CRITICAL + "You can not kick yourself, idiot!"));
                    } else {
                        clowder.notifyPlayer(player.field_70170_p, kickee, new ChatComponentText(CRITICAL + "You have been kicked from your faction!"));
                        clowder.removeMember(player.field_70170_p, kickee);
                        sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Kicked player " + kickee + "!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is not in your faction!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to kick members!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdListflags(ICommandSender sender, String page) {
        int fpp = 20;
        int p = CommandClowder.func_71526_a((ICommandSender)sender, (String)page);
        int pages = (int)Math.ceil((double)ClowderFlag.getFlags().size() / (double)fpp);
        if (p < 1 || p > pages) {
            p = 1;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "[" + p + "/" + pages + "] List of availible flags:"));
        for (int i = (p - 1) * fpp; i < p * fpp && i < ClowderFlag.values().length; ++i) {
            if (!ClowderFlag.values()[i].show) continue;
            sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + "-" + ClowderFlag.values()[i].name));
        }
    }

    private void cmdFlag(ICommandSender sender, String flag) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                ClowderFlag f = ClowderFlag.getFromName(flag.toLowerCase());
                if (f != ClowderFlag.NONE) {
                    clowder.flag = f;
                    sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Changed flag to " + flag + "!"));
                    PacketDispatcher.wrapper.sendTo((IMessage)new ClowderFlagPacket(clowder, ""), player);
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This flag does not exist!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to change this faction's flag!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdRetreat(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (!Clowder.retreating.contains(player.getDisplayName())) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "POV: I mog you"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdSethome(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts((int)player.field_70165_t, (int)player.field_70161_v);
                if (owner != null && owner.zone == ClowderTerritory.Zone.FACTION && owner.owner == clowder) {
                    if (clowder.sethomeDelay <= 0.0f) {
                        clowder.setHome(player.field_70165_t, player.field_70163_u, player.field_70161_v, (EntityPlayer)player);
                        clowder.notifyAll(player.field_70170_p, new ChatComponentText(INFO + "Home set!"));
                        clowder.addSethomeDelay(10.0f, player.field_70170_p);
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Please wait " + (int)clowder.sethomeDelay + " minutes to set home again!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can not set the home outside of your claimed land!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to set this faction's home point!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdSetAllyWarp(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts((int)player.field_70165_t, (int)player.field_70161_v);
                if (owner != null && owner.zone == ClowderTerritory.Zone.FACTION && owner.owner == clowder) {
                    if (clowder.sethomeDelay <= 0.0f) {
                        clowder.setAllyWarp(player.field_70165_t, player.field_70163_u, player.field_70161_v, (EntityPlayer)player);
                        clowder.notifyAll(player.field_70170_p, new ChatComponentText(INFO + "Ally Warp set!"));
                        clowder.addSethomeDelay(10.0f, player.field_70170_p);
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Please wait " + (int)clowder.sethomeDelay + " minutes to move the alliance rally-point!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can not set the Ally Warp outside of your claimed land!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to set this faction's Ally Warp point!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdHome(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts((int)player.field_70165_t, (int)player.field_70161_v);
            if (owner != null && (owner.zone == ClowderTerritory.Zone.WARZONE || owner.zone == ClowderTerritory.Zone.FACTION && owner.owner != clowder && clowder.allies.get(owner.owner) == null)) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can not teleport home in foreign territory!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Please stand still for 10 seconds!"));
                Clowder.teleports.put(System.currentTimeMillis() + 10000L, new Clowder.ScheduledTeleport(clowder.homeX, clowder.homeY, clowder.homeZ, player.getDisplayName(), true));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdAllyWarp(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        Clowder ally = Clowder.getClowderFromName(name);
        if (clowder != null) {
            if (ally != null) {
                ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts((int)player.field_70165_t, (int)player.field_70161_v);
                if (owner != null && (owner.zone == ClowderTerritory.Zone.WARZONE || owner.zone == ClowderTerritory.Zone.FACTION && owner.owner != clowder && clowder.allies.get(owner.owner) == null)) {
                    System.out.println("alliesS get owner name: " + clowder.alliesS.get(owner.owner.name) + " owner.owner name: " + owner.owner.name);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can not teleport to an Ally Warp from unfriendly territory!"));
                } else if (ally.allies.get(clowder) != null) {
                    if (ally.allyWarpX != 0 && ally.allyWarpY != 0 && ally.allyWarpZ != 0) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Please stand still for 10 seconds!"));
                        Clowder.teleports.put(System.currentTimeMillis() + 10000L, new Clowder.ScheduledTeleport(ally.allyWarpX, ally.allyWarpY, ally.allyWarpZ, player.getDisplayName(), true, true, ally.name));
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + name + " did not set an alliance rally-point!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + name + " is not our ally!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + name + " is not a valid faction!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdAddWarp(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.warps.containsKey(name)) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This warp already exists!"));
                return;
            }
            if (clowder.getPrestige() < (float)MainRegistry.warpCost) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You need at least " + MainRegistry.warpCost + " prestige to create a warp!"));
                return;
            }
            int code = clowder.tryAddWarp((EntityPlayer)player, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, name);
            if (code == 0) {
                clowder.notifyAll(player.field_70170_p, new ChatComponentText(INFO + "Created warp " + name + "!"));
                clowder.addPrestige(-MainRegistry.warpCost, player.field_70170_p);
                clowder.save(player.field_70170_p);
            } else if (code == 1) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Cannot create warp outside of your territory!"));
            } else if (code == 2) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "No nearby warp tents!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdDelWarp(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.warps.containsKey(name)) {
                clowder.warps.remove(name);
                clowder.save(player.field_70170_p);
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Deleted warp!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This warp does not exist!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdWarp(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.warps.containsKey(name)) {
                ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts((int)player.field_70165_t, (int)player.field_70161_v);
                if (owner != null && (owner.zone == ClowderTerritory.Zone.WARZONE || owner.zone == ClowderTerritory.Zone.FACTION && owner.owner != clowder && clowder.allies.get(owner.owner) == null)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can not warp in unfriendly territory!"));
                    return;
                }
                int[] warp = clowder.warps.get(name);
                if (warp == null) {
                    return;
                }
                IChunkProvider provider = player.field_70170_p.func_72863_F();
                for (int i = 2; i <= 5; ++i) {
                    int[] pos;
                    ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                    provider.func_73158_c(warp[0] + dir.offsetX * 2 >> 4, warp[2] + dir.offsetZ * 2 >> 4);
                    int tentX = warp[0] + dir.offsetX * 2;
                    int tentZ = warp[2] + dir.offsetZ * 2;
                    Block block = player.field_70170_p.func_147439_a(tentX, warp[1], tentZ);
                    if (block != ModBlocks.tp_tent || (pos = ((BlockDummyable)ModBlocks.tp_tent).findCore(player.field_70170_p, tentX, warp[1], tentZ)) == null) continue;
                    provider.func_73158_c(pos[0] >> 4, pos[2] >> 4);
                    TileEntityProp tent = (TileEntityProp)player.field_70170_p.func_147438_o(pos[0], pos[1], pos[2]);
                    if (!tent.warp.equals(name) || !tent.operational()) continue;
                    sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Please stand still for 10 seconds!"));
                    Clowder.teleports.put(System.currentTimeMillis() + 10000L, new Clowder.ScheduledTeleport(warp[0], warp[1], warp[2], player.getDisplayName(), name));
                    return;
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Warp tent not found! Make sure it still exists or remove this warp!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This warp does not exist!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdWarps(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "Availible warps:"));
            for (String s : clowder.warps.keySet()) {
                int[] pos = clowder.warps.get(s);
                sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + s));
                sender.func_145747_a((IChatComponent)new ChatComponentText(LIST + " x:" + pos[0] + " y:" + pos[1] + " z:" + pos[2]));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdBalance(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPrestige() > 0.0f) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Current prestige balance: " + LIST + clowder.getPrestige()));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "It seems like you're bankrupt."));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdDeposit(ICommandSender sender, String a) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        int amount = CommandClowder.func_71526_a((ICommandSender)sender, (String)a);
        if (clowder != null) {
            if (amount <= 0) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You cannot deposit 0 or less prestige!"));
                return;
            }
            for (int i = 0; i < amount; ++i) {
                if (!player.field_71071_by.func_146028_b(ModItems.province_point)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Deposited " + i + " prestige!"));
                    clowder.save(player.field_70170_p);
                    player.field_71069_bz.func_75142_b();
                    return;
                }
                player.field_71071_by.func_146026_a(ModItems.province_point);
                clowder.addPrestige(1.0f, player.field_70170_p);
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Deposited " + amount + " prestige!"));
            clowder.save(player.field_70170_p);
            player.field_71069_bz.func_75142_b();
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdWithdraw(ICommandSender sender, String a) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        int amount = CommandClowder.func_71526_a((ICommandSender)sender, (String)a);
        if (clowder != null) {
            if (amount <= 0) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You cannot withdraw 0 or less prestige!"));
                return;
            }
            amount = Math.min(amount, (int)clowder.getPrestige());
            if (clowder.getPrestige() == 0.0f) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "It seems like you're bankrupt."));
                return;
            }
            clowder.addPrestige(-1.0f, player.field_70170_p);
            for (int i = 0; i < amount; ++i) {
                if (player.field_71071_by.func_70441_a(new ItemStack(ModItems.province_point))) continue;
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Withdrew " + i + " prestige!"));
                clowder.save(player.field_70170_p);
                player.field_71069_bz.func_75142_b();
                return;
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Withdrew " + amount + " prestige!"));
            clowder.save(player.field_70170_p);
            player.field_71069_bz.func_75142_b();
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdClaim(ICommandSender sender) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                ClowderTerritory.TerritoryMeta meta = ClowderTerritory.territories.get(ClowderTerritory.coordsToCode(new ClowderTerritory.CoordPair(player.field_70176_ah, player.field_70164_aj)));
                if (meta.owner.zone == ClowderTerritory.Zone.WILDERNESS || meta.owner.zone == ClowderTerritory.Zone.FACTION && meta.owner.owner.getPrestige() <= 0.0f && meta.owner.owner.getPrestigeGen() - meta.owner.owner.getPrestigeReq() < 0.0f) {
                    TileEntity te = sender.func_130014_f_().func_147438_o(meta.flagX, meta.flagY, meta.flagZ);
                    if (te != null && te instanceof TileEntityFlagBig) {
                        TileEntityFlagBig flag = (TileEntityFlagBig)te;
                        if (clowder.getPrestige() >= (float)flag.getCost()) {
                            clowder.addPrestige(-flag.getCost(), sender.func_130014_f_());
                            clowder.addPrestigeReq(flag.getCost(), sender.func_130014_f_());
                            ClowderTerritory.Ownership oldOwner = meta.owner;
                            flag.owner = clowder;
                            flag.func_70296_d();
                            for (ClowderTerritory.CoordPair a : flag.claim) {
                                ClowderTerritory.setOwnerForCoord(sender.func_130014_f_(), a, clowder, flag.field_145851_c, flag.field_145848_d, flag.field_145849_e, flag.provinceName);
                            }
                            flag.isCappable = true;
                            MinecraftForge.EVENT_BUS.post((Event)new RegionOwnershipChangedEvent(oldOwner, meta.owner, flag.provinceName));
                            flag.func_70296_d();
                            ClowderData.getData(sender.func_130014_f_()).func_76185_a();
                        } else {
                            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You already claimed to your capacity. Get more prestige and make sure you have enough to maintain your claims!"));
                        }
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Wait.. there is no flag! Let an admin know!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You cannot claim here"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Your authority is not high enough to manage territory"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any clowder"));
        }
    }

    private void cmdPromote(ICommandSender sender, String promotee) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 2) {
                if (clowder.members.get(promotee) != null) {
                    if (clowder.getPermLevel(promotee) == 1) {
                        clowder.promote(player.field_70170_p, promotee);
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is already promoted!"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is not in your faction!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to promote members!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdDemote(ICommandSender sender, String demotee) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (clowder.getPermLevel(player.getDisplayName()) > 2) {
                if (clowder.members.get(demotee) != null) {
                    if (demotee.equals(player.getDisplayName())) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You can't demote yourself!"));
                        return;
                    }
                    if (clowder.getPermLevel(demotee) == 2) {
                        clowder.demote(player.field_70170_p, demotee);
                    } else if (clowder.getPermLevel(demotee) != 3) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is already demoted!"));
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Are you seriously trying to demote the faction's leader?"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is not in your faction!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to demote members!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdNameClaim(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowder.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
            return;
        }
        if (clowder.getPermLevel(player.getDisplayName()) < 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to rename land!"));
            return;
        }
        ClowderTerritory.TerritoryMeta meta = ClowderTerritory.getMetaFromIntCoords((int)player.field_70165_t, (int)player.field_70161_v);
        if (meta == null || meta.owner == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any claimed land!"));
            return;
        }
        if (meta.owner.owner != clowder) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You cannot rename foreign land!"));
            return;
        }
        ITerritoryProvider flag = (ITerritoryProvider)player.field_70170_p.func_147438_o(meta.flagX, meta.flagY, meta.flagZ);
        if (flag == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "The flag that is connected to this claim could not be found! Are the chunks unloaded?"));
            return;
        }
        flag.setClaimName(name);
        ((TileEntity)flag).func_70296_d();
        sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Your claim has been renamed! It might take a few moments for all chunks to assume the new name."));
        ClowderData.getData(player.field_70170_p).func_76185_a();
    }

    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return CommandClowder.func_71530_a((String[])p_71516_2_, (String[])MinecraftServer.func_71276_C().func_71213_z());
    }
}

