/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.command;

import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.data.ClowderData;
import com.hfr.packet.PacketDispatcher;
import com.hfr.packet.effect.ClowderFlagPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandClowderAdmin
extends CommandBase {
    public static final String ERROR = EnumChatFormatting.RED.toString();
    public static final String CRITICAL = EnumChatFormatting.DARK_RED.toString();
    public static final String TITLE = EnumChatFormatting.GOLD.toString();
    public static final String LIST = EnumChatFormatting.BLUE.toString();
    public static final String HELP = EnumChatFormatting.DARK_GREEN.toString();
    public static final String INFO = EnumChatFormatting.GREEN.toString();
    public static final String COMMAND = EnumChatFormatting.RED.toString();
    public static final String COMMAND_LEADER = EnumChatFormatting.DARK_RED.toString();
    public static final String COMMAND_ADMIN = EnumChatFormatting.DARK_PURPLE.toString();

    public String func_71517_b() {
        return "xclowder";
    }

    public List func_71514_a() {
        return new ArrayList(){
            {
                this.add("xclowder");
                this.add("xc");
            }
        };
    }

    public String func_71518_a(ICommandSender sender) {
        return "/xclowder help";
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (sender.func_130014_f_().field_73011_w.field_76574_g != 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(CRITICAL + "Critical error: CatFac only works in overworld!!"));
        }
        if (Clowder.clowders.size() == 0) {
            ClowderData.getData(sender.func_130014_f_());
        }
        if (args.length < 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + this.func_71518_a(sender)));
            return;
        }
        String cmd = args[0].toLowerCase();
        if (cmd.equals("help") || cmd.equals("man")) {
            if (args.length > 1) {
                this.cmdHelp(sender, args[1]);
            } else {
                this.cmdHelp(sender, "1");
            }
            return;
        }
        if ((cmd.equals("forcejoin") || cmd.equals("fj")) && args.length > 1) {
            this.cmdForcejoin(sender, args[1]);
            return;
        }
        if ((cmd.equals("forcedisband") || cmd.equals("fd")) && args.length > 1) {
            this.cmdForcedisband(sender, args[1]);
            return;
        }
        if (cmd.equals("hijack") || cmd.equals("hi")) {
            this.cmdHijack(sender);
            return;
        }
        if (cmd.equals("deletedata") || cmd.equals("deldat")) {
            this.cmdDeletedata(sender);
            return;
        }
        if ((cmd.equals("setclaim") || cmd.equals("sc")) && args.length > 3) {
            this.cmdSetclaim(sender, args[1], args[2], args[3]);
            return;
        }
        if ((cmd.equals("addprestige") || cmd.equals("ap")) && args.length > 2) {
            this.cmdAddPrestige(sender, args[1], args[2]);
            return;
        }
        if (cmd.equals("disband") && args.length > 1) {
            this.cmdDisband(sender, args[1]);
            return;
        }
        if (cmd.equals("rename") && args.length > 1) {
            this.cmdRename(sender, args[1]);
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + this.func_71518_a(sender)));
    }

    private void cmdHelp(ICommandSender sender, String page) {
        int p = CommandClowderAdmin.func_71526_a((ICommandSender)sender, (String)page);
        int pages = 1;
        if (p < 1 || p > pages) {
            p = 1;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(HELP + "/clowder [command] <args...> {optional args...}"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Commands [" + p + "/" + pages + "]:"));
        if (p == 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-forcejoin <name>" + TITLE + " - Forcefully joins a faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-forcekick <name>" + TITLE + " - Forcefully kicks a player from his faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-forcedisband <name>" + TITLE + " - Forcefully disbands faction"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-hijack" + TITLE + " - Forcefully overrides leadership"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-deletedata" + TITLE + " - Deletes all clowder data (CAUTION!!)"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-setclaim <wild/safe/war> <s/c> <radius>" + TITLE + " - Claims chunks in a radius (square or circular)"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-addprestige <name> <amount>" + TITLE + " - Adds prestige (neg values to subtract)"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "/clowder help 2"));
        }
        if (p == 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-disband <name>" + TITLE + " - Disbands a faction, name parameter for confirmation"));
            sender.func_145747_a((IChatComponent)new ChatComponentText(COMMAND_ADMIN + "-rename <name>" + TITLE + " - Renames your faction"));
        }
    }

    private void cmdForcejoin(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder == null) {
            Clowder tojoin = Clowder.getClowderFromName(name);
            if (tojoin != null) {
                tojoin.addMember(player.field_70170_p, player.getDisplayName());
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "You have joined " + tojoin.getDecoratedName() + "!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "There is no faction with this name!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are already in a faction!"));
        }
    }

    private void cmdForcekick(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        EntityPlayer kickee = player.field_70170_p.func_72924_a(name);
        Clowder clowder = Clowder.getClowderFromPlayer(kickee);
        if (clowder != null) {
            if (!clowder.leader.equals(kickee.getDisplayName())) {
                clowder.removeMember(player.field_70170_p, kickee.getDisplayName());
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "You have kicked " + kickee.getDisplayName() + " from the faction " + clowder.getDecoratedName() + "!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You cannot kick a leader from his faction!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This player is not in a faction!"));
        }
    }

    private void cmdForcedisband(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromName(name);
        if (clowder != null) {
            clowder.disbandClowder(player.field_70170_p);
            sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Faction " + clowder.getDecoratedName() + " has been disbanded!"));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "There is no faction with this name!"));
        }
    }

    private void cmdHijack(ICommandSender sender) {
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (!clowder.leader.equals(player.getDisplayName())) {
                clowder.transferOwnership(player.field_70170_p, player.getDisplayName());
                sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "You have assumed ownership of this faction!"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are already this faction's leader!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdDeletedata(ICommandSender sender) {
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        ClowderTerritory.territories.clear();
        while (Clowder.clowders.size() > 0) {
            Clowder.clowders.get(0).disbandClowder(player.field_70170_p);
        }
        Clowder.inverseMap.clear();
        Clowder.retreating.clear();
        ClowderData.getData(player.field_70170_p).func_76185_a();
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.OBFUSCATED + "" + EnumChatFormatting.DARK_PURPLE + "All data has been deleted!"));
    }

    private void cmdSetclaim(ICommandSender sender, String zo, String s, String r) {
        ClowderTerritory.Zone zone;
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        ClowderTerritory.Zone zone2 = zo.equals("war") ? ClowderTerritory.Zone.WARZONE : (zo.equals("safe") ? ClowderTerritory.Zone.SAFEZONE : (zone = zo.equals("wild") ? ClowderTerritory.Zone.WILDERNESS : null));
        int shape = s.equals("s") ? 0 : (s.equals("c") ? 1 : -1);
        int radius = CommandClowderAdmin.func_71526_a((ICommandSender)sender, (String)r);
        int xCoord = (int)player.field_70165_t;
        int zCoord = (int)player.field_70161_v;
        if (zone != null) {
            if (shape >= 0) {
                if (shape == 0) {
                    --radius;
                }
                if (radius < 0 || radius > 25) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Invalid radius! Must be between 1 and 25"));
                } else {
                    int count = 0;
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            int posX = xCoord + x * 16;
                            int posZ = zCoord + z * 16;
                            ClowderTerritory.CoordPair loc = ClowderTerritory.getCoordPair(posX, posZ);
                            if (shape != 0 && !(Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0)) < (double)radius)) continue;
                            ClowderTerritory.setZoneForCoord(player.field_70170_p, loc, zone);
                            ++count;
                        }
                    }
                    sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Changed " + count + " chunks to " + zone.toString() + "!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Invalid shape! Applicable: s (square), c (circle)"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Invalid zone! Applicable: wild, safe, war"));
        }
    }

    private void cmdAddPrestige(ICommandSender sender, String name, String amount) {
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromName(name);
        int am = CommandClowderAdmin.func_71526_a((ICommandSender)sender, (String)amount);
        if (clowder != null) {
            clowder.addPrestige(am, player.field_70170_p);
            sender.func_145747_a((IChatComponent)new ChatComponentText(INFO + "Added " + am + " prestige to faction " + clowder.getDecoratedName() + "!"));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "There is no faction with this name!"));
        }
    }

    private void cmdDisband(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (name.equals(clowder.name)) {
                if (clowder.disbandClowder((EntityPlayer)player)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(CRITICAL + "Your faction was disbanded!"));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Can not disband a faction you do not own!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "Confirmation unsuccessful. Please enter the faction name to disband the faction."));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    private void cmdRename(ICommandSender sender, String name) {
        EntityPlayerMP player = CommandClowderAdmin.func_71521_c((ICommandSender)sender);
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)player);
        if (clowder != null) {
            if (Clowder.getClowderFromName(name) == null) {
                if (clowder.getPermLevel(player.getDisplayName()) > 1) {
                    clowder.rename(name, (EntityPlayer)player);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(TITLE + "Renamed faction to " + name + "!"));
                    PacketDispatcher.wrapper.sendTo((IMessage)new ClowderFlagPacket(clowder, ""), player);
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You lack the permissions to rename this faction!"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "This name is already taken!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ERROR + "You are not in any faction!"));
        }
    }

    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return CommandClowderAdmin.func_71530_a((String[])p_71516_2_, (String[])MinecraftServer.func_71276_C().func_71213_z());
    }
}

