/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.command;

import com.hfr.main.MainRegistry;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandStoneDrop
extends CommandBase {
    public String func_71517_b() {
        return "stonedrop";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/stonedrop <rarity> OR /stonedrop list OR /stonedrop remove [index]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Usage: " + this.func_71518_a(sender)));
            return;
        }
        String subCommand = args[0];
        if (subCommand.toLowerCase().equals("list")) {
            this.handleListCommand(sender);
        } else if (subCommand.toLowerCase().equals("remove")) {
            this.handleRemoveCommand(sender, args);
        } else {
            this.handleAddCommand(sender, args);
        }
    }

    private void handleListCommand(ICommandSender sender) {
        List<ItemStack> drops = MainRegistry.customDrops;
        if (drops.isEmpty()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("No custom stone drops set."));
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText("Custom Stone Drops:"));
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack stack = drops.get(i);
            sender.func_145747_a((IChatComponent)new ChatComponentText(i + 1 + ". " + stack.func_82833_r() + " (Chance: " + MainRegistry.customDropChances.get(i) + ")"));
        }
    }

    private void handleRemoveCommand(ICommandSender sender, String[] args) {
        int index;
        if (args.length < 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Usage: /stonedrop remove [index]"));
            return;
        }
        try {
            index = Integer.parseInt(args[1]) - 1;
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Invalid index. Must be a number."));
            return;
        }
        if (index < 0 || index >= MainRegistry.customDrops.size()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Invalid index. Out of range."));
            return;
        }
        ItemStack removed = MainRegistry.customDrops.remove(index);
        double removedChance = MainRegistry.customDropChances.remove(index);
        MainRegistry.saveCustomDrops();
        sender.func_145747_a((IChatComponent)new ChatComponentText("Removed custom drop: " + removed.func_82833_r() + " (Chance: " + removedChance + ")"));
    }

    private void handleAddCommand(ICommandSender sender, String[] args) {
        double rarity;
        try {
            rarity = Double.parseDouble(args[0]);
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Invalid rarity. Must be a number, e.g. 0.25"));
            return;
        }
        if (!(sender instanceof EntityPlayerMP)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Only a player can run this command in-game."));
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("You must be holding an item or block to set the custom drop."));
            return;
        }
        MainRegistry.customDrops.add(heldItem.func_77946_l());
        MainRegistry.customDropChances.add(rarity);
        MainRegistry.saveCustomDrops();
        sender.func_145747_a((IChatComponent)new ChatComponentText("Stone drop added!  Item: " + heldItem.func_82833_r() + " | Rarity (chance): " + rarity));
    }
}

