/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class CBTData
extends WorldSavedData {
    public List<CBTEntry> entries = new ArrayList<CBTEntry>();

    public CBTData(String name) {
        super(name);
    }

    public static CBTData getData(World worldObj) {
        CBTData data = (CBTData)worldObj.perWorldStorage.func_75742_a(CBTData.class, "hfr_cbt");
        if (data == null) {
            worldObj.perWorldStorage.func_75745_a("hfr_cbt", (WorldSavedData)new CBTData("hfr_cbt"));
            data = (CBTData)worldObj.perWorldStorage.func_75742_a(CBTData.class, "hfr_cbt");
        }
        return data;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int size = nbt.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            this.entries.add(new CBTEntry(nbt.func_74779_i(i + "_name"), nbt.func_74767_n(i + "_fps"), nbt.func_74767_n(i + "_tilt"), nbt.func_74767_n(i + "_shader")));
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("size", this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            nbt.func_74778_a(i + "_name", this.entries.get((int)i).player);
            nbt.func_74757_a(i + "_fps", this.entries.get((int)i).fps);
            nbt.func_74757_a(i + "_tilt", this.entries.get((int)i).tilt);
            nbt.func_74757_a(i + "_shader", this.entries.get((int)i).shader);
        }
    }

    public CBTEntry getEntryByPlayerName(String player) {
        for (CBTEntry entry : this.entries) {
            if (!entry.player.equals(player)) continue;
            return entry;
        }
        return null;
    }

    public static class CBTEntry {
        public String player;
        public boolean fps;
        public boolean tilt;
        public boolean shader;

        public CBTEntry(String player) {
            this.player = player;
        }

        public CBTEntry(String player, boolean fps, boolean tilt, boolean shader) {
            this.player = player;
            this.fps = fps;
            this.tilt = tilt;
            this.shader = shader;
        }
    }
}

