/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class MarketData {
    private static final String FILE_NAME = "marketsavedata.json";
    public HashMap<String, List<Offer>> offers = new HashMap();
    private boolean dirty = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MarketData getData(World world) {
        File file = MarketData.getMarketFile(world);
        if (!file.exists()) {
            MarketData data = new MarketData();
            data.saveToFile(file);
            return data;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            Type type = new TypeToken<HashMap<String, List<Offer>>>(){}.getType();
            MarketData data = new MarketData();
            data.offers = (HashMap)GSON.fromJson((Reader)reader, type);
            if (data.offers == null) {
                data.offers = new HashMap();
            }
            MarketData marketData = data;
            return marketData;
        }
        catch (JsonParseException e) {
            System.err.println("Error parsing MarketData JSON: " + e.getMessage());
            e.printStackTrace();
            MarketData marketData = new MarketData();
            return marketData;
        }
        catch (IOException e) {
            System.err.println("Error reading MarketData JSON: " + e.getMessage());
            e.printStackTrace();
            MarketData marketData = new MarketData();
            return marketData;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) {
        if (!this.dirty) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            GSON.toJson(this.offers, (Appendable)writer);
            this.dirty = false;
        }
        catch (IOException e) {
            System.err.println("Error saving MarketData to JSON: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    private static String serializeItemStackArray(ItemStack[] items) {
        NBTTagList nbtList = new NBTTagList();
        for (ItemStack item : items) {
            if (item == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            item.func_77955_b(nbt);
            nbtList.func_74742_a((NBTBase)nbt);
        }
        NBTTagCompound wrapper = new NBTTagCompound();
        wrapper.func_74782_a("Items", (NBTBase)nbtList);
        return wrapper.toString();
    }

    private static ItemStack[] deserializeItemStackArray(String serialized) {
        try {
            NBTTagCompound wrapper = CompressedStreamTools.func_152457_a((byte[])serialized.getBytes("UTF-8"), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
            NBTTagList nbtList = wrapper.func_150295_c("Items", 10);
            ItemStack[] items = new ItemStack[nbtList.func_74745_c()];
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                items[i] = ItemStack.func_77949_a((NBTTagCompound)nbtList.func_150305_b(i));
            }
            return items;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ItemStack[0];
        }
    }

    public void writeOffers(NBTTagCompound nbt, String name, List<Offer> offers) {
        for (int index = 0; index < offers.size(); ++index) {
            NBTTagList list = new NBTTagList();
            Offer offer = offers.get(index);
            ItemStack[] items = offer.getItemStacks();
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                NBTTagCompound nbt1 = new NBTTagCompound();
                nbt1.func_74774_a("slot" + index, (byte)i);
                items[i].func_77955_b(nbt1);
                list.func_74742_a((NBTBase)nbt1);
            }
            nbt.func_74782_a("items" + name + index, (NBTBase)list);
            nbt.func_74768_a("count" + name + index, offer.capacity);
        }
    }

    public void writeMarketFromName(NBTTagCompound nbt, String name) {
        List<Offer> market = this.offers.get(name);
        if (market == null) {
            return;
        }
        nbt.func_74778_a("market", name);
        nbt.func_74768_a("offercount", market.size());
        this.writeOffers(nbt, name, market);
    }

    public void readMarketFromPacket(NBTTagCompound nbt) {
        String name = nbt.func_74779_i("market");
        int offerCount = nbt.func_74762_e("offercount");
        for (int off = 0; off < offerCount; ++off) {
            this.readOffers(nbt, name, off);
        }
    }

    public void readOffers(NBTTagCompound nbt, String name, int index) {
        ItemStack[] slots = new ItemStack[4];
        NBTTagList list = nbt.func_150295_c("items" + name + index, 10);
        for (int j = 0; j < list.func_74745_c(); ++j) {
            NBTTagCompound nbt1 = list.func_150305_b(j);
            byte b0 = nbt1.func_74771_c("slot" + index);
            if (b0 < 0 || b0 >= slots.length) continue;
            slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
        int capacity = nbt.func_74762_e("items" + name + index);
        List<Offer> offers = this.offers.get(name);
        if (offers == null) {
            offers = new ArrayList<Offer>();
        }
        offers.add(new Offer(slots, capacity));
        this.offers.put(name, offers);
    }

    public static File getMarketFile(World world) {
        File worldDir = world.func_72860_G().func_75765_b();
        return new File(worldDir, FILE_NAME);
    }

    public static class Offer {
        public ItemStack[] offer;
        public int capacity;

        public Offer(ItemStack[] offer, int capacity) {
            this.offer = offer;
            this.capacity = capacity;
        }

        public ItemStack[] getItemStacks() {
            ItemStack[] itemStacks = new ItemStack[this.offer.length];
            for (int i = 0; i < this.offer.length; ++i) {
                itemStacks[i] = this.offer[i] != null ? Offer.deserializeItemStack(String.valueOf(this.offer[i])) : null;
            }
            return itemStacks;
        }

        private static String serializeItemStack(ItemStack itemStack) {
            NBTTagCompound nbt = new NBTTagCompound();
            itemStack.func_77955_b(nbt);
            return nbt.toString();
        }

        private static ItemStack deserializeItemStack(String nbtString) {
            try {
                byte[] nbtData = nbtString.getBytes("UTF-8");
                NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])nbtData, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
                return ItemStack.func_77949_a((NBTTagCompound)nbt);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

