/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.data;

import com.hfr.main.MainRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class StockData
extends WorldSavedData {
    public static List<Stock> stocks = new ArrayList<Stock>();
    public static List<StockEntry> entries = new ArrayList<StockEntry>();

    public StockData() {
        super("hfr_stocks");
    }

    public StockData(String name) {
        super(name);
    }

    public int getShares(String player, Stock stock) {
        for (StockEntry entry : entries) {
            if (!entry.player.equals(player) || entry.stock != stock) continue;
            return entry.shares;
        }
        return 0;
    }

    public Stock getStockByShort(String shortname) {
        for (Stock stock : stocks) {
            if (!stock.shortname.equals(shortname)) continue;
            return stock;
        }
        return null;
    }

    public void setShares(String player, Stock stock, int shares) {
        this.func_76185_a();
        for (StockEntry entry : entries) {
            if (!entry.player.equals(player) || entry.stock != stock) continue;
            entry.shares = shares;
            return;
        }
        entries.add(new StockEntry(stock, player, shares));
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (int i = 0; i < stocks.size(); ++i) {
            stocks.get(i).readFromNBT(nbt, i);
        }
        int count = nbt.func_74762_e("count");
        for (int i = 0; i < count; ++i) {
            entries.add(new StockEntry(stocks.get(nbt.func_74762_e(i + "_stock")), nbt.func_74779_i(i + "_player"), nbt.func_74762_e(i + "_shares")));
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        int i;
        for (i = 0; i < stocks.size(); ++i) {
            stocks.get(i).writeToNBT(nbt, i);
        }
        nbt.func_74768_a("count", entries.size());
        for (i = 0; i < entries.size(); ++i) {
            nbt.func_74768_a(i + "_stock", stocks.indexOf(StockData.entries.get((int)i).stock));
            nbt.func_74778_a(i + "_player", StockData.entries.get((int)i).player);
            nbt.func_74768_a(i + "_shares", StockData.entries.get((int)i).shares);
        }
    }

    public static StockData getData(World worldObj) {
        StockData data = (StockData)worldObj.perWorldStorage.func_75742_a(StockData.class, "hfr_stocks");
        if (data == null) {
            worldObj.perWorldStorage.func_75745_a("hfr_stocks", (WorldSavedData)new StockData());
            data = (StockData)worldObj.perWorldStorage.func_75742_a(StockData.class, "hfr_stocks");
        }
        return data;
    }

    public Stock getByInt(int i) {
        return stocks.get(i %= stocks.size());
    }

    public static class StockEntry {
        public Stock stock;
        public String player;
        public int shares;

        public StockEntry(Stock stock, String player, int shares) {
            this.stock = stock;
            this.player = player;
            this.shares = shares;
        }
    }

    public static class Stock {
        public String name;
        public String shortname;
        public float[] value;
        public float u2chance;
        public float u1chance;
        public float nchance;
        public float d1chance;
        public float d2chance;
        public int shares;
        public EnumStockPhase phase = EnumStockPhase.N;
        Random rand = new Random();

        public Stock(String name, String shortname, float value, float u2chance, float u1chance, float nchance, float d1chance, float d2chance) {
            this.name = name;
            this.shortname = shortname;
            this.value = new float[15];
            this.u2chance = u2chance;
            this.u1chance = u1chance;
            this.nchance = nchance;
            this.d1chance = d1chance;
            this.d2chance = d2chance;
            for (int i = 0; i < 15; ++i) {
                this.value[i] = value;
            }
        }

        public Stock(String name, String shortname, float[] value, int shares) {
            this.name = name;
            this.shortname = shortname;
            this.value = value;
            this.shares = shares;
        }

        public void writeToNBT(NBTTagCompound nbt, int index) {
            for (int i = 0; i < 15; ++i) {
                nbt.func_74776_a(index + "_" + i + "_value", this.value[i]);
            }
        }

        public void readFromNBT(NBTTagCompound nbt, int index) {
            for (int i = 0; i < 15; ++i) {
                this.value[i] = nbt.func_74760_g(index + "_" + i + "_value");
            }
        }

        public void rollTheDice() {
            if (this.value[14] < 5.0f) {
                this.phase = EnumStockPhase.U2;
                return;
            }
            if (this.value[14] > 95.0f) {
                this.phase = EnumStockPhase.D2;
                return;
            }
            if (this.phase != EnumStockPhase.N && this.rand.nextFloat() * 100.0f < this.nchance) {
                this.phase = EnumStockPhase.N;
                return;
            }
            if (this.phase == EnumStockPhase.N) {
                switch (this.rand.nextInt(4)) {
                    case 0: {
                        if (!(this.rand.nextFloat() * 100.0f < this.u1chance)) break;
                        this.phase = EnumStockPhase.U1;
                        if (MainRegistry.u1en && !MainRegistry.u1.isEmpty()) {
                            this.sendMsg(MainRegistry.u1.get(this.rand.nextInt(MainRegistry.u1.size())));
                        }
                        return;
                    }
                    case 1: {
                        if (!(this.rand.nextFloat() * 100.0f < this.d1chance)) break;
                        this.phase = EnumStockPhase.D1;
                        if (MainRegistry.d1en && !MainRegistry.d1.isEmpty()) {
                            this.sendMsg(MainRegistry.d1.get(this.rand.nextInt(MainRegistry.d1.size())));
                        }
                        return;
                    }
                    case 2: {
                        if (!(this.rand.nextFloat() * 100.0f < this.u2chance)) break;
                        this.phase = EnumStockPhase.U2;
                        if (MainRegistry.u2en && !MainRegistry.u2.isEmpty()) {
                            this.sendMsg(MainRegistry.u2.get(this.rand.nextInt(MainRegistry.u2.size())));
                        }
                        return;
                    }
                    case 3: {
                        if (!(this.rand.nextFloat() * 100.0f < this.d2chance)) break;
                        this.phase = EnumStockPhase.D2;
                        if (MainRegistry.d2en && !MainRegistry.d2.isEmpty()) {
                            this.sendMsg(MainRegistry.d2.get(this.rand.nextInt(MainRegistry.d2.size())));
                        }
                        return;
                    }
                }
            }
        }

        private void sendMsg(String s) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "[" + EnumChatFormatting.BLUE + "Stock Market" + EnumChatFormatting.GOLD + "] " + s.replace("%s", this.shortname)));
        }

        public void update() {
            switch (this.phase) {
                case U2: {
                    this.value[14] = this.value[14] + this.rand.nextFloat() * 1.75f * 2.0f - 0.0f;
                    break;
                }
                case U1: {
                    this.value[14] = this.value[14] + this.rand.nextFloat() * 1.5f * 2.0f - 0.5f;
                    break;
                }
                case D1: {
                    this.value[14] = this.value[14] - this.rand.nextFloat() * 1.5f * 2.0f - 0.5f;
                    break;
                }
                case D2: {
                    this.value[14] = this.value[14] - this.rand.nextFloat() * 1.75f * 2.0f - 0.0f;
                    break;
                }
                case N: {
                    this.value[14] = this.value[14] + this.rand.nextFloat() * 1.25f * 2.0f - 1.25f;
                }
            }
        }
    }

    public static enum EnumStockPhase {
        U2,
        U1,
        N,
        D1,
        D2;

    }
}

