/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.entity.logic;

import com.hfr.main.MainRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityNuclearBlast
extends Entity {
    int progress;
    int size;
    float strength;
    int dist;
    int blast;
    boolean simple = MainRegistry.nukeSimple;
    Random field_70146_Z = new Random();

    public EntityNuclearBlast(World p_i1582_1_) {
        super(p_i1582_1_);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.fire();
            this.explode();
            if (this.progress > this.size) {
                this.func_70106_y();
            }
        }
    }

    private void explode() {
        int steps = MainRegistry.nukeStep;
        for (int i = this.progress; i < this.progress + steps; ++i) {
            Vec3 vec = Vec3.func_72443_a((double)i, (double)0.0, (double)0.0);
            double circ = (double)(i * 2) * Math.PI;
            int count = (int)(circ / (double)this.dist);
            for (int j = 0; j < count; ++j) {
                vec.func_72442_b(this.field_70146_Z.nextFloat() * 360.0f);
                EntityTNTPrimed scapegoat = new EntityTNTPrimed(this.field_70170_p);
                double y = (double)this.field_70170_p.func_72976_f((int)(this.field_70165_t + vec.field_72450_a), (int)(this.field_70161_v + vec.field_72449_c)) + 1.5;
                if (this.simple) {
                    y = this.field_70163_u;
                }
                this.field_70170_p.func_72876_a((Entity)scapegoat, this.field_70165_t + vec.field_72450_a, y, this.field_70161_v + vec.field_72449_c, this.strength, true);
            }
        }
        this.progress += steps;
    }

    private void fire() {
        List list = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)this.size), (double)(this.field_70163_u - (double)this.size), (double)(this.field_70161_v - (double)this.size), (double)(this.field_70165_t + (double)this.size), (double)(this.field_70163_u + (double)this.size), (double)(this.field_70161_v + (double)this.size)));
        for (Entity e : list) {
            double dist;
            if (!(e instanceof EntityPlayer) && e instanceof EntityLivingBase || !((dist = Math.sqrt(Math.pow(e.field_70165_t - this.field_70165_t, 2.0) + Math.pow(e.field_70163_u - this.field_70163_u, 2.0) + Math.pow(e.field_70161_v - this.field_70161_v, 2.0))) <= (double)this.size) || !this.canHurt(e)) continue;
            e.func_70015_d(5);
            e.func_70097_a(MainRegistry.blast, (float)MainRegistry.nukeDamage);
        }
    }

    private boolean canHurt(Entity e) {
        EntityPlayer p;
        if (e instanceof EntityPlayer && (p = (EntityPlayer)e).func_110124_au().equals("192af5d7-ed0f-48d8-bd89-9d41af8524f8")) {
            return false;
        }
        return !EntityNuclearBlast.isObstructed(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v);
    }

    private static boolean canBlock(Block b) {
        return MainRegistry.blastShields.contains(b);
    }

    public static boolean isObstructed(World world, double x, double y, double z, double a, double b, double c) {
        Vec3 vector = Vec3.func_72443_a((double)(a - x), (double)(b - y), (double)(c - z));
        double length = vector.func_72433_c();
        Vec3 nVec = vector.func_72432_b();
        float i = 0.0f;
        while ((double)i < length) {
            Block tile = world.func_147439_a((int)Math.round(x + nVec.field_72450_a * (double)i), (int)Math.round(y + nVec.field_72448_b * (double)i), (int)Math.round(z + nVec.field_72449_c * (double)i));
            if (EntityNuclearBlast.canBlock(tile)) {
                return true;
            }
            i += 0.25f;
        }
        return false;
    }

    public static EntityNuclearBlast statFac(World world, double posX, double posY, double posZ, int size, float strength, int dist, int killblast) {
        EntityNuclearBlast blast = new EntityNuclearBlast(world);
        blast.field_70165_t = posX;
        blast.field_70163_u = posY;
        blast.field_70161_v = posZ;
        blast.size = size;
        blast.strength = strength;
        blast.dist = dist;
        blast.blast = killblast;
        return blast;
    }

    public EntityNuclearBlast setSimple(boolean b) {
        this.simple = b;
        return this;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70173_aa = nbt.func_74762_e("age");
        this.progress = nbt.func_74762_e("progress");
        this.size = nbt.func_74762_e("size");
        this.strength = nbt.func_74760_g("strength");
        this.dist = nbt.func_74762_e("dist");
        this.blast = nbt.func_74762_e("blast");
        this.simple = nbt.func_74767_n("simple");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("age", this.field_70173_aa);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74776_a("strength", this.strength);
        nbt.func_74768_a("dist", this.dist);
        nbt.func_74768_a("blast", this.blast);
        nbt.func_74757_a("simple", this.simple);
    }
}

