/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.entity.missile;

import com.hfr.entity.IChunkLoader;
import com.hfr.entity.IEmpable;
import com.hfr.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public abstract class EntityMissileBaseSimple
extends Entity
implements IChunkLoader,
IEmpable {
    int startX;
    int startZ;
    int startY;
    int targetX;
    int targetZ;
    private ForgeChunkManager.Ticket loaderTicket;
    public float health = MainRegistry.mHealth;
    public int mode = 0;
    int timer;
    List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityMissileBaseSimple(World p_i1582_1_) {
        super(p_i1582_1_);
        this.field_70158_ak = true;
        this.startX = (int)this.field_70165_t;
        this.startY = (int)this.field_70163_u;
        this.startZ = (int)this.field_70161_v;
        this.targetX = (int)this.field_70165_t;
        this.targetZ = (int)this.field_70161_v;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_85032_ar() || this.mode == 1) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.health -= p_70097_2_;
            if (this.health <= 0.0f) {
                this.func_70106_y();
                this.killMissile();
            }
        }
        return true;
    }

    private void killMissile() {
        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false);
    }

    public EntityMissileBaseSimple(World world, float x, float y, float z, int a, int b) {
        super(world);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.startX = (int)x;
        this.startY = (int)y;
        this.startZ = (int)z;
        this.targetX = a;
        this.targetZ = b;
        this.field_70181_x = 0.1;
        this.func_70105_a(1.5f, 1.5f);
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_75682_a(8, (Object)Float.valueOf(this.health));
        this.field_70180_af.func_75682_a(9, (Object)0);
        this.field_70180_af.func_75682_a(10, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.targetX = nbt.func_74762_e("tX");
        this.targetZ = nbt.func_74762_e("tZ");
        this.startX = nbt.func_74762_e("sX");
        this.startY = nbt.func_74762_e("sY");
        this.startZ = nbt.func_74762_e("sZ");
        this.mode = nbt.func_74762_e("mode");
        this.timer = nbt.func_74762_e("timer");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tZ", this.targetZ);
        nbt.func_74768_a("sX", this.startX);
        nbt.func_74768_a("sY", this.startY);
        nbt.func_74768_a("sZ", this.startZ);
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74768_a("timer", this.timer);
    }

    protected void rotation() {
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    public void func_70071_h_() {
        Vec3 movement;
        Vec3 vec31;
        Vec3 vec3;
        MovingObjectPosition movingobjectposition;
        this.field_70180_af.func_75692_b(8, (Object)Float.valueOf(this.health));
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.mode == 0) {
            if (this.field_70181_x < 7.5) {
                this.field_70181_x += 0.025;
            }
            if (this.field_70163_u > (double)MainRegistry.mDespawn) {
                this.timer = this.getDelay();
                this.mode = 1;
                Vec3 move = this.getS2T();
                move = move.func_72432_b();
                double offset = this.getOffset();
                move.field_72450_a *= offset;
                move.field_72449_c *= offset;
                this.func_70012_b((double)this.targetX - move.field_72450_a, MainRegistry.mSpawn, (double)this.targetZ - move.field_72449_c, 0.0f, 0.0f);
                Vec3 aim = Vec3.func_72443_a((double)(this.field_70165_t - (double)this.targetX), (double)(this.field_70163_u - (double)this.startY), (double)(this.field_70161_v - (double)this.targetZ));
                aim = aim.func_72432_b();
                this.field_70159_w = aim.field_72450_a * -5.0;
                this.field_70181_x = aim.field_72448_b * -5.0;
                this.field_70179_y = aim.field_72449_c * -5.0;
            }
        } else if (this.mode == 1) {
            --this.timer;
            if (this.field_70180_af.func_75679_c(10) <= 0) {
                this.mode = 2;
            }
        } else if (Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72433_c() < 5.0) {
            this.field_70181_x -= 0.1;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(9, (Object)this.mode);
            this.field_70180_af.func_75692_b(10, (Object)this.timer);
        }
        if (this.field_70170_p.field_72995_K) {
            this.mode = this.field_70180_af.func_75679_c(9);
            this.timer = this.field_70180_af.func_75679_c(10);
        }
        if (this.mode != 1) {
            this.func_70012_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y, 0.0f, 0.0f);
        }
        this.rotation();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_75679_c(9) != 1) {
            MainRegistry.proxy.howDoIUseTheZOMG(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0);
        }
        if ((movingobjectposition = this.field_70170_p.func_72933_a(vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), vec31 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y)))) != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70012_b(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d, 0.0f, 0.0f);
                this.onImpact();
            }
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.loadNeighboringChunks((int)(this.field_70165_t / 16.0), (int)(this.field_70161_v / 16.0));
        }
        if (!this.field_70170_p.field_72995_K && (movement = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y)).func_72433_c() < 0.1) {
            this.func_70106_y();
        }
    }

    private Vec3 getS2T() {
        return Vec3.func_72443_a((double)(this.targetX - this.startX), (double)0.0, (double)(this.targetZ - this.startZ));
    }

    private int getDelay() {
        Vec3 vec = this.getS2T();
        double length = vec.func_72433_c();
        int dlay = (int)(length / 10.0 * 4.0);
        return dlay;
    }

    private double getOffset() {
        Vec3 vec = this.getS2T();
        double length = vec.func_72433_c();
        double offset = length / 50.0 * 8.0;
        if (offset > 800.0) {
            offset = 800.0;
        }
        return offset;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 500000.0;
    }

    public abstract void onImpact();

    public abstract int getMissileType();

    public abstract boolean getIsBreaching();

    public void onForceImpact() {
        this.func_70097_a(DamageSource.field_76377_j, 1000.0f);
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            ArrayList<ChunkCoordIntPair> oldChunks = new ArrayList<ChunkCoordIntPair>(this.loadedChunks);
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ - 1));
            oldChunks.removeAll(this.loadedChunks);
            for (ChunkCoordIntPair chunk : oldChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                if (this.loaderTicket.getChunkList().contains((Object)chunk)) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    @Override
    public void pulse() {
        if (this.mode == 0) {
            this.targetX = (int)((double)this.targetX + this.field_70146_Z.nextGaussian());
            this.targetZ = (int)((double)this.targetZ + this.field_70146_Z.nextGaussian());
        }
        if (this.mode == 2) {
            this.field_70159_w += this.field_70146_Z.nextGaussian() * 0.01;
            this.field_70179_y += this.field_70146_Z.nextGaussian() * 0.01;
        }
    }
}

