/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.hfr.handler.BobbyExplosion;
import com.hfr.util.FourInts;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;

public class BobbyBreaker {
    private static final Gson gson = new Gson();
    public static HashMap<String, HashMap<Integer, Integer>> resistance = new HashMap();
    public static HashMap<FourInts, Float> values = new HashMap();

    public static void removeEntry(int x, int y, int z, int dim) {
        FourInts pos = new FourInts(x, y, z, dim);
        values.remove(pos);
    }

    public static int getResistanceValue(Block b, int meta) {
        HashMap<Integer, Integer> map = resistance.get(b.func_149739_a().replace("tile.", ""));
        if (map == null) {
            return 0;
        }
        Integer res = map.get(meta);
        if (res == null) {
            res = map.get(-1);
        }
        if (res != null) {
            return res;
        }
        return 0;
    }

    public static void setValue(int x, int y, int z, int dim, float value) {
        FourInts pos = new FourInts(x, y, z, dim);
        values.put(pos, Float.valueOf(value));
    }

    public static float getValue(int x, int y, int z, int dim) {
        Float val = values.get(new FourInts(x, y, z, dim));
        if (val == null) {
            return -1.0f;
        }
        return val.floatValue();
    }

    public static void handleExplosionEvent(ExplosionEvent.Detonate event) {
        World world = event.world;
        if (!world.field_72995_K && event.explosion.field_82755_b) {
            ArrayList<ChunkPosition> rem = new ArrayList<ChunkPosition>();
            double x = event.explosion.field_77284_b;
            double y = event.explosion.field_77285_c;
            double z = event.explosion.field_77282_d;
            int dim = event.world.field_73011_w.field_76574_g;
            float strength = event.explosion.field_77280_f * 10.0f;
            for (ChunkPosition pos : event.getAffectedBlocks()) {
                int meta;
                Block b = world.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                int res = BobbyBreaker.getResistanceValue(b, meta = world.func_72805_g(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c));
                if (res <= 0) continue;
                rem.add(pos);
            }
            event.getAffectedBlocks().removeAll(rem);
            ArrayList offsets = new ArrayList(){
                {
                    this.addAll(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));
                }
            };
            Collections.shuffle(offsets);
            offsets.add(0, ForgeDirection.UNKNOWN);
            for (int i = 0; i < offsets.size(); ++i) {
                ForgeDirection dir = (ForgeDirection)offsets.get(i);
                int ix = (int)x + dir.offsetX;
                int iy = (int)y + dir.offsetY;
                int iz = (int)z + dir.offsetZ;
                if (world.func_147439_a(ix, iy, iz) != Blocks.field_150350_a) continue;
                BobbyExplosion explosion = new BobbyExplosion(world, event.explosion.field_77283_e, (double)ix + 0.5, (double)iy + 0.5, (double)iz + 0.5, strength);
                explosion.func_77278_a();
                explosion.func_77279_a(false);
                return;
            }
            BobbyExplosion explosion = new BobbyExplosion(world, event.explosion.field_77283_e, x, y, z, strength);
            explosion.func_77278_a();
            explosion.func_77279_a(false);
        }
    }

    public static void handleDigEvent(BlockEvent.BreakEvent event) {
        if (!event.world.field_72995_K) {
            BobbyBreaker.removeEntry(event.x, event.y, event.z, event.world.field_73011_w.field_76574_g);
        }
    }

    public static void loadConfiguration(String name) throws JsonIOException, JsonSyntaxException, FileNotFoundException {
        resistance.clear();
        values.clear();
        System.out.println("Attempting to read bobbybreaker configuration...");
        JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(name), JsonObject.class);
        for (Map.Entry child : json.entrySet()) {
            if (!((JsonElement)child.getValue()).isJsonPrimitive()) continue;
            try {
                String[] frags = ((String)child.getKey()).split("\\|");
                String block = frags[0];
                int meta = -1;
                if (frags.length > 1) {
                    meta = Integer.parseInt(frags[1]);
                }
                int health = ((JsonElement)child.getValue()).getAsInt();
                Block b = Block.func_149684_b((String)block);
                if (b == Blocks.field_150350_a || b == null) {
                    throw new Exception("Failed to read config line, block not found!");
                }
                HashMap<Integer, Integer> map = resistance.get(b.func_149739_a().replace("tile.", ""));
                if (map != null) {
                    map.put(meta, health);
                    continue;
                }
                map = new HashMap();
                map.put(meta, health);
                resistance.put(b.func_149739_a().replace("tile.", ""), map);
            }
            catch (Exception ex) {
                System.out.println("Error while reading line! (Is the JSON malformed?)");
                System.out.println((String)child.getKey() + " " + ((JsonElement)child.getValue()).toString());
            }
        }
        System.out.println("Config loaded without dying. Yay!");
        for (String key : resistance.keySet()) {
            HashMap<Integer, Integer> map = resistance.get(key);
            System.out.println("Entry for " + key);
            for (Integer k : map.keySet()) {
                System.out.println("Meta " + k + ": " + map.get(k) + " health");
            }
        }
    }
}

