/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.handler;

import com.hfr.packet.PacketDispatcher;
import com.hfr.packet.effect.AuxParticlePacketNT;
import com.hfr.packet.effect.ExplosionSoundPacket;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplosionSound {
    public static final double max = 8.0;

    public static void handleExplosion(World world, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        double x = explosion.field_77284_b;
        double y = explosion.field_77285_c;
        double z = explosion.field_77282_d;
        float pow = explosion.field_77280_f;
        if (pow < 3.0f) {
            return;
        }
        if ((double)pow > 8.0) {
            pow = 8.0f;
        }
        double farRange = 1000.0 * (double)pow / 8.0;
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new ExplosionSoundPacket((int)x, (int)y, (int)z, pow), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, farRange));
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "explosion");
        data.func_74776_a("strength", pow);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 150.0));
    }

    public static void handleClient(EntityPlayer player, int x, int y, int z, float pow) {
        World world = player.field_70170_p;
        double closeRange = 50.0 * (double)pow / 8.0;
        double mediumRange = 250.0 * (double)pow / 8.0;
        double farRange = 1000.0 * (double)pow / 8.0;
        double distance = Math.sqrt(Math.pow(player.field_70165_t - (double)x, 2.0) + Math.pow(player.field_70163_u - (double)y, 2.0) + Math.pow(player.field_70161_v - (double)z, 2.0));
        if (distance <= closeRange) {
            world.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, "hfr:explosion.close", 100.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f, false);
        } else if (distance <= mediumRange) {
            world.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, "hfr:explosion.medium", 100.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f, false);
        } else if (distance <= farRange) {
            world.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, "hfr:explosion.rumble", 100.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f, false);
        }
    }
}

