/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.handler;

import com.hfr.entity.EntityNukeCloudSmall;
import com.hfr.entity.logic.EntityBlast;
import com.hfr.entity.logic.EntityNuclearBlast;
import com.hfr.items.ModItems;
import com.hfr.main.MainRegistry;
import com.hfr.main.ReflectionEngine;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;

public class SLBMHandler {
    public static int flight;
    public static int warhead;

    public static void tryLaunch(World world, EntityPlayer player, int xCoord, int zCoord) {
        if (!world.field_72995_K && SLBMHandler.hasSLBM(player)) {
            Object vehicle = SLBMHandler.getVehicle(player);
            int type = SLBMHandler.getFlightType(vehicle);
            int range = SLBMHandler.getRange(vehicle);
            int strength = SLBMHandler.getStrength(vehicle);
            int warhead = SLBMHandler.getWarhead(vehicle);
            int delay = SLBMHandler.getDelay(vehicle) * 1000;
            float posX = (float)player.field_70165_t;
            float posY = (float)player.field_70163_u;
            float posZ = (float)player.field_70161_v;
            Item missile = SLBMHandler.getMissile(type, warhead);
            Entity entVehicle = (Entity)vehicle;
            if (player.field_71071_by.func_146028_b(missile) && entVehicle.getEntityData().func_74763_f("slbmLastShot") + (long)delay < System.currentTimeMillis()) {
                double d = Math.sqrt(Math.pow(player.field_70165_t - (double)xCoord, 2.0) + Math.pow(player.field_70161_v - (double)zCoord, 2.0));
            }
            world.func_72908_a((double)posX, (double)posY, (double)posZ, "hfr:block.buttonNo", 1.0f, 1.0f);
        }
    }

    public static boolean hasSLBM(EntityPlayer player) {
        Object vehicle = SLBMHandler.getVehicle(player);
        return SLBMHandler.getFlightType(vehicle) > 0;
    }

    public static Object getVehicle(EntityPlayer player) {
        Object vehicle = ReflectionEngine.getVehicleFromSeat(player.field_70154_o);
        return vehicle;
    }

    public static int getFlightType(Object vehicle) {
        return SLBMHandler.getInteger(vehicle, "slbmFlightType");
    }

    public static int getDelay(Object vehicle) {
        return SLBMHandler.getInteger(vehicle, "slbmDelay");
    }

    public static int getRange(Object vehicle) {
        return SLBMHandler.getInteger(vehicle, "slbmRange");
    }

    public static int getStrength(Object vehicle) {
        return SLBMHandler.getInteger(vehicle, "slbmStrength");
    }

    public static int getWarhead(Object vehicle) {
        return SLBMHandler.getInteger(vehicle, "slbmWarheadType");
    }

    public static int getInteger(Object vehicle, String name) {
        if (vehicle != null) {
            int value = ReflectionEngine.hasValue(vehicle, Integer.class, name, 0);
            return value;
        }
        return 0;
    }

    public static Item getMissileFromPlayer(EntityPlayer player) {
        Object vehicle = SLBMHandler.getVehicle(player);
        if (vehicle != null) {
            int flight = SLBMHandler.getFlightType(vehicle);
            int warhead = SLBMHandler.getWarhead(vehicle);
            return SLBMHandler.getMissile(flight, warhead);
        }
        return ModItems.missile_decoy;
    }

    public static Item getMissileFromClient() {
        return SLBMHandler.getMissile(flight, warhead);
    }

    public static Item getMissile(int flightType, int warhead) {
        if (flightType == 1) {
            if (warhead == 0) {
                return ModItems.slbm_martin_1;
            }
            if (warhead == 1) {
                return ModItems.slbm_martin_2;
            }
            if (warhead == 2) {
                return ModItems.slbm_martin_3;
            }
        } else if (flightType == 2) {
            if (warhead == 0) {
                return ModItems.slbm_pegasus_1;
            }
            if (warhead == 1) {
                return ModItems.slbm_pegasus_2;
            }
            if (warhead == 2) {
                return ModItems.slbm_pegasus_3;
            }
        } else if (flightType == 3) {
            if (warhead == 0) {
                return ModItems.slbm_spear_1;
            }
            if (warhead == 1) {
                return ModItems.slbm_spear_2;
            }
            if (warhead == 2) {
                return ModItems.slbm_spear_3;
            }
        } else if (flightType == 4) {
            if (warhead == 0) {
                return ModItems.slbm_pepper_1;
            }
            if (warhead == 1) {
                return ModItems.slbm_pepper_2;
            }
            if (warhead == 2) {
                return ModItems.slbm_pepper_3;
            }
        }
        return ModItems.missile_decoy;
    }

    public static void explode(Entity missile, int strength, int type) {
        World worldObj = missile.field_70170_p;
        double posX = missile.field_70165_t;
        double posY = missile.field_70163_u;
        double posZ = missile.field_70161_v;
        if (type == 0 || type == 1) {
            EntityTNTPrimed scapegoat = new EntityTNTPrimed(worldObj);
            worldObj.func_72885_a((Entity)scapegoat, posX, posY, posZ, (float)strength, type == 1, true);
            worldObj.func_72838_d((Entity)EntityBlast.statFac(worldObj, posX, posY, posZ, strength * 2, 100, 0, 0.0f, false));
            if (strength >= 35) {
                worldObj.func_72838_d((Entity)EntityNukeCloudSmall.statFac(worldObj, posX, posY, posZ));
            }
        }
        if (type == 2) {
            worldObj.func_72838_d((Entity)EntityNukeCloudSmall.statFac(worldObj, posX, posY, posZ).scaleMulti(2.5f));
            worldObj.func_72838_d((Entity)EntityNuclearBlast.statFac(worldObj, posX, posY, posZ, strength, MainRegistry.nukeStrength, MainRegistry.nukeDist, MainRegistry.nukeKill));
        }
    }
}

