/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.items;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBattery
extends Item
implements IEnergyContainerItem {
    public int capacity;

    public ItemBattery(int cap) {
        this.capacity = cap;
        this.func_77656_e(100);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (simulate) {
            return 0;
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
            return 0;
        }
        int stored = this.getEnergyStored(container);
        int receive = Math.min(Math.min(this.capacity - stored, this.capacity / 100), maxReceive);
        container.field_77990_d.func_74768_a("charge", stored += receive);
        return receive;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (simulate) {
            return 0;
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
            return 0;
        }
        int stored = this.getEnergyStored(container);
        int extract = Math.min(Math.min(stored, this.capacity / 100), maxExtract);
        container.field_77990_d.func_74768_a("charge", stored -= extract);
        return extract;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
            return 0;
        }
        return container.field_77990_d.func_74762_e("charge");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return 1.0;
        }
        return 1.0 - (double)(this.getEnergyStored(stack) * 100 / this.capacity) / 100.0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(this.getEnergyStored(stack) + "/" + this.capacity + "RF");
    }

    public boolean isRepairable() {
        return false;
    }
}

