/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.packet.client;

import com.hfr.blocks.machine.MachineMarket;
import com.hfr.clowder.Clowder;
import com.hfr.data.MarketData;
import com.hfr.data.StockData;
import com.hfr.main.MainRegistry;
import com.hfr.packet.PacketDispatcher;
import com.hfr.packet.effect.ParticleControlPacket;
import com.hfr.packet.tile.AuxGaugePacket;
import com.hfr.packet.tile.RailgunFirePacket;
import com.hfr.packet.tile.SchematicPreviewPacket;
import com.hfr.schematic.Schematic;
import com.hfr.tileentity.clowder.TileEntityFlag;
import com.hfr.tileentity.machine.TileEntityForceField;
import com.hfr.tileentity.machine.TileEntityFoundry;
import com.hfr.tileentity.machine.TileEntityMachineBuilder;
import com.hfr.tileentity.machine.TileEntityMachineEMP;
import com.hfr.tileentity.machine.TileEntityMachineMarket;
import com.hfr.tileentity.machine.TileEntityMachineRadar;
import com.hfr.tileentity.machine.TileEntityMachineTurbine;
import com.hfr.tileentity.weapon.TileEntityNaval;
import com.hfr.tileentity.weapon.TileEntityRailgun;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;

public class AuxButtonPacket
implements IMessage {
    int x;
    int y;
    int z;
    int value;
    int id;

    public AuxButtonPacket() {
    }

    public AuxButtonPacket(int x, int y, int z, int value, int id) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.value = value;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.value = buf.readInt();
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.value);
        buf.writeInt(this.id);
    }

    public static int countItems(EntityPlayer player, Item item, int meta) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack slot = player.field_71071_by.func_70301_a(i);
            if (slot == null || slot.func_77973_b() != item || slot.func_77960_j() != meta) continue;
            count += slot.field_77994_a;
        }
        return count;
    }

    public static void removeItems(EntityPlayer player, Item item, int meta, int count) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack slot = player.field_71071_by.func_70301_a(i);
            if (slot == null || slot.func_77973_b() != item || slot.func_77960_j() != meta) continue;
            if (slot.field_77994_a < count) {
                count -= slot.field_77994_a;
                player.field_71071_by.func_70298_a(i, slot.field_77994_a);
            } else {
                player.field_71071_by.func_70298_a(i, count);
                count = 0;
            }
            if (count > 0) continue;
            return;
        }
    }

    public static class Handler
    implements IMessageHandler<AuxButtonPacket, IMessage> {
        public IMessage onMessage(AuxButtonPacket m, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            try {
                TileEntity gun;
                TileEntity field;
                TileEntity te = p.field_70170_p.func_147438_o(m.x, m.y, m.z);
                if (te instanceof TileEntityForceField) {
                    field = (TileEntityForceField)te;
                    boolean bl = field.isOn = !field.isOn;
                }
                if (te instanceof TileEntityMachineRadar) {
                    field = (TileEntityMachineRadar)te;
                    ++((TileEntityMachineRadar)field).mode;
                    if (((TileEntityMachineRadar)field).mode > 3) {
                        ((TileEntityMachineRadar)field).mode -= 4;
                    }
                }
                if (te instanceof TileEntityRailgun) {
                    gun = (TileEntityRailgun)te;
                    if (m.id == 1) {
                        if (gun.canFire()) {
                            gun.fireDelay = TileEntityRailgun.cooldownDurationTicks;
                            PacketDispatcher.wrapper.sendToAll((IMessage)new RailgunFirePacket(m.x, m.y, m.z));
                            p.field_70170_p.func_72908_a((double)m.x, (double)m.y, (double)m.z, "hfr:block.buttonYes", 1.0f, 1.0f);
                            p.field_70170_p.func_72908_a((double)m.x, (double)m.y, (double)m.z, "hfr:block.railgunCharge", 10.0f, 1.0f);
                        } else {
                            p.field_70170_p.func_72908_a((double)m.x, (double)m.y, (double)m.z, "hfr:block.buttonNo", 1.0f, 1.0f);
                        }
                    }
                }
                if (te instanceof TileEntityNaval) {
                    gun = (TileEntityNaval)te;
                    if (m.id == 1) {
                        if (gun.canFire()) {
                            Vec3 vec = Vec3.func_72443_a((double)6.0, (double)0.0, (double)0.0);
                            vec.func_72446_c((float)((double)gun.pitch * Math.PI / 180.0));
                            vec.func_72442_b((float)((double)gun.yaw * Math.PI / 180.0));
                            double fX = (double)gun.field_145851_c + 0.5 + vec.field_72450_a;
                            double fY = (double)(gun.field_145848_d + 1) + vec.field_72448_b;
                            double fZ = (double)gun.field_145849_e + 0.5 + vec.field_72449_c;
                            PacketDispatcher.wrapper.sendToAll((IMessage)new ParticleControlPacket(fX, fY, fZ, 4));
                        }
                        gun.tryFire();
                    }
                }
                if (te instanceof TileEntityMachineMarket) {
                    TileEntityMachineMarket market = (TileEntityMachineMarket)te;
                    StockData data = StockData.getData(market.func_145831_w());
                    if (m.id == 0) {
                        market.buyStock(data.getByInt(m.value), p.getDisplayName());
                    }
                    if (m.id == 1) {
                        market.sellStock(data.getByInt(m.value), p.getDisplayName());
                    }
                }
                if (te instanceof TileEntityMachineBuilder) {
                    Schematic schem;
                    TileEntityMachineBuilder builder = (TileEntityMachineBuilder)te;
                    if (m.id == 0) {
                        if (builder.preview == null) {
                            builder.preview = MainRegistry.schems.get(m.value);
                            PacketDispatcher.wrapper.sendToAll((IMessage)new SchematicPreviewPacket(m.x, m.y, m.z, MainRegistry.schems.get(m.value)));
                        } else {
                            builder.preview = null;
                            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(m.x, m.y, m.z, 0, 0));
                        }
                    }
                    if (m.id == 1) {
                        schem = MainRegistry.schems.get(m.value);
                        builder.construct(schem);
                    }
                    if (m.id == 2) {
                        schem = MainRegistry.schems.get(m.value);
                        builder.deconstruct(schem);
                    }
                }
                if (te instanceof TileEntityMachineEMP) {
                    TileEntityMachineEMP emp = (TileEntityMachineEMP)te;
                    if (m.id == 0) {
                        boolean bl = emp.isOn = !emp.isOn;
                    }
                    if (m.id == 1) {
                        emp.range = m.value;
                    }
                }
                if (te instanceof TileEntityFlag) {
                    TileEntityFlag flag = (TileEntityFlag)te;
                    if (flag.isClaimed) {
                        if (m.id == 0) {
                            if (flag.mode != 1) {
                                flag.setMode(1);
                            } else {
                                flag.setMode(0);
                            }
                        }
                        if (m.id == 1) {
                            if (flag.mode != 2) {
                                flag.setMode(2);
                            } else {
                                flag.setMode(0);
                            }
                        }
                        if (m.id == 2) {
                            if (flag.mode != 3) {
                                flag.setMode(3);
                            } else {
                                flag.setMode(0);
                            }
                        }
                        if (flag.mode > 0) {
                            flag.generateClaim();
                        }
                    }
                }
                if (te instanceof TileEntityMachineTurbine) {
                    TileEntityMachineTurbine turbine = (TileEntityMachineTurbine)te;
                    turbine.mode = m.id;
                }
                if (te instanceof TileEntityFoundry) {
                    TileEntityFoundry foundry = (TileEntityFoundry)te;
                    if (m.id == 0) {
                        foundry.decrement();
                    } else if (m.id == 1) {
                        foundry.increment();
                    }
                }
                if (te instanceof MachineMarket.TileEntityMarket) {
                    MarketData data = MarketData.getData(p.field_70170_p);
                    MachineMarket.TileEntityMarket market = (MachineMarket.TileEntityMarket)te;
                    if (data.offers.get(market.name) == null) {
                        System.out.println("There's no market with the name: " + market.name);
                        return null;
                    }
                    if (m.value < 0 || m.value >= data.offers.get(market.name).size()) {
                        System.out.println("The selected offer is out of bounds for market: " + market.name);
                        System.out.println("Offer index: " + m.value);
                        return null;
                    }
                    MarketData.Offer offer = data.offers.get(market.name).get(m.value);
                    if (offer != null) {
                        int i;
                        Clowder c = Clowder.getClowderFromPlayer((EntityPlayer)p);
                        if (offer.capacity != 0 && c == null) {
                            p.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "This offer is only available to factions."));
                            return null;
                        }
                        if (offer.capacity > 0) {
                            Integer history = c != null ? c.offerHistory.get(offer) : null;
                            int purchases = history != null ? history : 0;
                            ++purchases;
                            if (c != null) {
                                c.offerHistory.put(offer, purchases);
                            }
                            if (purchases > offer.capacity) {
                                p.field_70170_p.func_72956_a((Entity)p, "hfr:block.buttonNo", 1.0f, 1.0f);
                                p.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "This item is currently out of stock! Come back tomorrow."));
                                return null;
                            }
                        }
                        ItemStack[] items = offer.offer;
                        ItemStack item = items[0];
                        boolean hasRequiredItems = true;
                        for (i = 1; i < 4; ++i) {
                            int count;
                            if (items[i] == null || (count = AuxButtonPacket.countItems((EntityPlayer)p, items[i].func_77973_b(), items[i].func_77960_j())) >= items[i].field_77994_a) continue;
                            hasRequiredItems = false;
                            break;
                        }
                        if (hasRequiredItems) {
                            p.field_70170_p.func_72956_a((Entity)p, "hfr:block.buttonYes", 1.0f, 1.0f);
                            for (i = 1; i < 4; ++i) {
                                if (items[i] == null) continue;
                                AuxButtonPacket.removeItems((EntityPlayer)p, items[i].func_77973_b(), items[i].func_77960_j(), items[i].field_77994_a);
                            }
                            if (!p.field_71071_by.func_70441_a(item.func_77946_l())) {
                                p.func_71019_a(item.func_77946_l(), true);
                            }
                            p.field_71069_bz.func_75142_b();
                        } else {
                            p.field_70170_p.func_72956_a((Entity)p, "hfr:block.buttonNo", 1.0f, 1.0f);
                            p.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You lack required items."));
                        }
                    } else {
                        System.out.println("The selected offer is apparently null for market: " + market.name);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

