/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.packet.effect;

import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderFlag;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.main.MainRegistry;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;

public class ClowderFlagPacket
implements IMessage {
    int flag;
    int color;
    String name;
    String title;

    public ClowderFlagPacket() {
        this.title = " ";
    }

    public ClowderFlagPacket(Clowder clowder, String title) {
        this.flag = clowder.flag.ordinal();
        this.color = clowder.color;
        this.name = clowder.getDecoratedName();
        this.title = title;
        if (title == null) {
            title = " ";
        }
    }

    public ClowderFlagPacket(ClowderFlag flag, int color, String name, String title) {
        this.flag = flag.ordinal();
        this.color = color;
        this.name = name;
        this.title = " ";
    }

    public ClowderFlagPacket(String special) {
        if (special.equals(ClowderTerritory.Zone.WILDERNESS.toString())) {
            this.flag = -1;
            this.color = 0xFFFFFF;
            this.name = "Wilderness";
        }
        if (special.equals(ClowderTerritory.Zone.SAFEZONE.toString())) {
            this.flag = -2;
            this.color = 0xFF8000;
            this.name = "Safe Zone";
        }
        if (special.equals(ClowderTerritory.Zone.WARZONE.toString())) {
            this.flag = -3;
            this.color = 0xFF0000;
            this.name = "War Zone";
        }
        if (this.title == null) {
            this.title = " ";
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.flag = buf.readInt();
        this.color = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.title = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.flag);
        buf.writeInt(this.color);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.title);
    }

    public static class Handler
    implements IMessageHandler<ClowderFlagPacket, IMessage> {
        public IMessage onMessage(ClowderFlagPacket m, MessageContext ctx) {
            if (m.flag > 0) {
                ClowderFlag flag = ClowderFlag.values()[m.flag];
                MainRegistry.proxy.updateFlag(flag.getFlag(), flag.getFlagOverlay(), m.color, m.name, m.title);
            } else {
                MainRegistry.proxy.updateFlag(null, m.flag == -3 ? ClowderFlag.WARZONE : (m.flag == -2 ? ClowderFlag.SAFEZONE : ClowderFlag.WILDERNESS), m.color, m.name, m.title);
            }
            Minecraft.func_71410_x().field_71439_g.func_85030_a("hfr:item.doot", 0.5f, 1.0f);
            return null;
        }
    }
}

