/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.packet.effect;

import com.hfr.main.MainRegistry;
import com.hfr.rvi.RVICommon;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public class RVIPacket
implements IMessage {
    RVICommon.Indicator[] indicators;

    public RVIPacket() {
    }

    public RVIPacket(RVICommon.Indicator[] indicators) {
        if (indicators == null) {
            indicators = new RVICommon.Indicator[]{};
        }
        this.indicators = indicators;
    }

    public void fromBytes(ByteBuf buf) {
        this.indicators = new RVICommon.Indicator[buf.readInt()];
        for (int i = 0; i < this.indicators.length; ++i) {
            this.indicators[i] = new RVICommon.Indicator(buf.readDouble(), buf.readDouble(), buf.readDouble(), RVICommon.RVIType.values()[buf.readInt()]);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.indicators.length);
        for (int i = 0; i < this.indicators.length; ++i) {
            buf.writeDouble(this.indicators[i].x);
            buf.writeDouble(this.indicators[i].y);
            buf.writeDouble(this.indicators[i].z);
            buf.writeInt(this.indicators[i].type.ordinal());
        }
    }

    public static class Handler
    implements IMessageHandler<RVIPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(RVIPacket m, MessageContext ctx) {
            MainRegistry.proxy.addRVIs(Arrays.asList(m.indicators));
            return null;
        }
    }
}

