/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.packet.tile;

import com.hfr.main.MainRegistry;
import com.hfr.render.hud.RenderRadarScreen;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;

public class SRadarPacket
implements IMessage {
    RenderRadarScreen.Blip[] blips;
    boolean sufficient;
    boolean enabled;
    int offset;
    int range;

    public SRadarPacket() {
    }

    public SRadarPacket(RenderRadarScreen.Blip[] blips, boolean sufficient, boolean enabled, int offset, int range) {
        if (blips == null) {
            blips = new RenderRadarScreen.Blip[]{};
        }
        this.blips = blips;
        this.sufficient = sufficient;
        this.enabled = enabled;
        this.offset = offset;
        this.range = range;
    }

    public void fromBytes(ByteBuf buf) {
        this.sufficient = buf.readBoolean();
        this.enabled = buf.readBoolean();
        this.offset = buf.readInt();
        this.range = buf.readInt();
        this.blips = new RenderRadarScreen.Blip[buf.readInt()];
        for (int i = 0; i < this.blips.length; ++i) {
            this.blips[i] = new RenderRadarScreen.Blip(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readShort());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.sufficient);
        buf.writeBoolean(this.enabled);
        buf.writeInt(this.offset);
        buf.writeInt(this.range);
        buf.writeInt(this.blips.length);
        for (int i = 0; i < this.blips.length; ++i) {
            buf.writeFloat(this.blips[i].x);
            buf.writeFloat(this.blips[i].y);
            buf.writeFloat(this.blips[i].z);
            buf.writeFloat(this.blips[i].posX);
            buf.writeFloat(this.blips[i].posZ);
            buf.writeShort(this.blips[i].type);
        }
    }

    public static class Handler
    implements IMessageHandler<SRadarPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SRadarPacket m, MessageContext ctx) {
            MainRegistry.proxy.clearBlips(m.sufficient, m.enabled, m.offset, m.range);
            if (m.blips != null) {
                for (RenderRadarScreen.Blip blip : m.blips) {
                    MainRegistry.proxy.addBlip(blip.x, blip.y, blip.z, blip.posX, blip.posZ, blip.type);
                }
            }
            return null;
        }
    }
}

