/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.packet.tile;

import com.hfr.data.StockData;
import com.hfr.tileentity.machine.TileEntityDisplay;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;

public class StockDisplayPacket
implements IMessage {
    int x;
    int y;
    int z;
    String name;
    String shortname;
    float[] values;
    int index;

    public StockDisplayPacket() {
    }

    public StockDisplayPacket(int x, int y, int z, String name, String shortname, float[] values, int index) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.shortname = shortname;
        this.values = values;
        this.index = index;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.shortname = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.values = new float[15];
        for (int i = 0; i < 15; ++i) {
            this.values[i] = buf.readFloat();
        }
        this.index = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.shortname);
        for (int i = 0; i < 15; ++i) {
            buf.writeFloat(this.values[i]);
        }
        buf.writeInt(this.index);
    }

    public static class Handler
    implements IMessageHandler<StockDisplayPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(StockDisplayPacket m, MessageContext ctx) {
            try {
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(m.x, m.y, m.z);
                if (te != null && te instanceof TileEntityDisplay) {
                    TileEntityDisplay display = (TileEntityDisplay)te;
                    display.stock = new StockData.Stock(m.name, m.shortname, m.values, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

