/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.packet.tile;

import com.hfr.data.StockData;
import com.hfr.tileentity.machine.TileEntityMachineMarket;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;

public class StockPacket
implements IMessage {
    String name;
    String shortname;
    float[] values;
    int shares;
    int index;

    public StockPacket() {
    }

    public StockPacket(String name, String shortname, float[] values, int shares, int index) {
        this.name = name;
        this.shortname = shortname;
        this.values = values;
        this.shares = shares;
        this.index = index;
    }

    public void fromBytes(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.shortname = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.values = new float[15];
        for (int i = 0; i < 15; ++i) {
            this.values[i] = buf.readFloat();
        }
        this.shares = buf.readInt();
        this.index = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.shortname);
        for (int i = 0; i < 15; ++i) {
            buf.writeFloat(this.values[i]);
        }
        buf.writeInt(this.shares);
        buf.writeInt(this.index);
    }

    public static class Handler
    implements IMessageHandler<StockPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(StockPacket m, MessageContext ctx) {
            while (TileEntityMachineMarket.stocks.size() <= m.index) {
                TileEntityMachineMarket.stocks.add(null);
            }
            TileEntityMachineMarket.stocks.set(m.index, new StockData.Stock(m.name, m.shortname, m.values, m.shares));
            return null;
        }
    }
}

