/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.packet.tile;

import com.hfr.tileentity.machine.TileEntityMachineRadar;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;

public class TESRadarPacket
implements IMessage {
    TileEntityMachineRadar.RadarEntry[] blips;
    int x;
    int y;
    int z;
    int mode;

    public TESRadarPacket() {
    }

    public TESRadarPacket(TileEntityMachineRadar.RadarEntry[] blips, int x, int y, int z, int mode) {
        if (blips == null) {
            blips = new TileEntityMachineRadar.RadarEntry[]{};
        }
        this.blips = blips;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = mode;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mode = buf.readInt();
        this.blips = new TileEntityMachineRadar.RadarEntry[buf.readInt()];
        for (int i = 0; i < this.blips.length; ++i) {
            this.blips[i] = new TileEntityMachineRadar.RadarEntry(buf.readInt(), buf.readInt(), buf.readInt(), ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.mode);
        buf.writeInt(this.blips.length);
        for (int i = 0; i < this.blips.length; ++i) {
            buf.writeInt(this.blips[i].posX);
            buf.writeInt(this.blips[i].posY);
            buf.writeInt(this.blips[i].posZ);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.blips[i].name);
        }
    }

    public static class Handler
    implements IMessageHandler<TESRadarPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(TESRadarPacket m, MessageContext ctx) {
            TileEntityMachineRadar te = (TileEntityMachineRadar)Minecraft.func_71410_x().field_71441_e.func_147438_o(m.x, m.y, m.z);
            try {
                te.nearbyMissiles.clear();
                te.mode = m.mode;
                if (m.blips != null) {
                    for (TileEntityMachineRadar.RadarEntry blip : m.blips) {
                        te.nearbyMissiles.add(new TileEntityMachineRadar.RadarEntry(blip.posX, blip.posY, blip.posZ, blip.name));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

