/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.pon4;

import com.hfr.pon4.CachedWorld;
import com.hfr.pon4.ExplosionController;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldController {
    private static ConcurrentHashMap<Integer, CachedWorld> cache = new ConcurrentHashMap();
    public static Lock cacheLock = new ReentrantLock();

    public static CachedWorld getWorld(int dimension) {
        return cache.get(dimension);
    }

    @SubscribeEvent
    public void WorldUnloadEvent(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.world.field_73011_w.field_76574_g == 0) {
            ExplosionController.affectedBlocks.clear();
        }
        cache.remove(event.world.field_73011_w.field_76574_g);
    }

    @SubscribeEvent
    public void WorldLoadEvent(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        cache.put(event.world.field_73011_w.field_76574_g, new CachedWorld(event.world));
    }

    @SubscribeEvent
    public void ChunkLoadEvent(ChunkEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        CachedWorld world = cache.get(event.world.field_73011_w.field_76574_g);
        if (world == null) {
            world = new CachedWorld(event.world);
            cache.put(event.world.field_73011_w.field_76574_g, world);
        }
        world.addChunk(event.getChunk());
    }

    @SubscribeEvent
    public void ChunkUnLoadEvent(ChunkEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        CachedWorld world = cache.get(event.world.field_73011_w.field_76574_g);
        if (world != null) {
            world.removeChunk(event.getChunk());
        }
    }
}

