/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.render.hud;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderRadarScreen {
    private static final ResourceLocation base = new ResourceLocation("hfr:textures/hud/radarscreen.png");
    private static final ResourceLocation error = new ResourceLocation("hfr:textures/hud/radarscreen_altitude.png");
    private static final ResourceLocation combat = new ResourceLocation("hfr:textures/hud/radarscreen_zoom.png");
    private static final ResourceLocation blipGreen = new ResourceLocation("hfr:textures/hud/blip.png");
    private static final ResourceLocation blipCircle = new ResourceLocation("hfr:textures/hud/blipLarge.png");
    private static final ResourceLocation blipX = new ResourceLocation("hfr:textures/hud/blipX.png");
    private static final ResourceLocation blipRed = new ResourceLocation("hfr:textures/hud/blipRed.png");
    private static final ResourceLocation blipDanger = new ResourceLocation("hfr:textures/hud/blipDanger.png");
    private static final ResourceLocation blipUnknown = new ResourceLocation("hfr:textures/hud/blipUnknown.png");
    private static final ResourceLocation blipToaster = new ResourceLocation("hfr:textures/hud/toaster.png");
    private static final ResourceLocation blipMissileUp = new ResourceLocation("hfr:textures/hud/blipMissileUp.png");
    private static final ResourceLocation blipMissileDown = new ResourceLocation("hfr:textures/hud/blipMissileDown.png");
    private static final ResourceLocation blipAB = new ResourceLocation("hfr:textures/hud/blipAB.png");
    private static final ResourceLocation north = new ResourceLocation("hfr:textures/hud/north.png");
    private static final ResourceLocation south = new ResourceLocation("hfr:textures/hud/south.png");
    private static final ResourceLocation east = new ResourceLocation("hfr:textures/hud/east.png");
    private static final ResourceLocation west = new ResourceLocation("hfr:textures/hud/west.png");
    public static List<Blip> blips = new ArrayList<Blip>();
    public static boolean sufficient;
    public static float scale;

    public static void renderRadar(int offset, int range, boolean zoom) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int width = minecraft.field_71443_c;
        int height = minecraft.field_71440_d;
        int size = (int)((double)height * 0.075 * (double)scale);
        int marginX = 10;
        int marginY = 10 + offset;
        double zLevel = 0.0;
        float blipSize = (float)size * 0.025f;
        float compassSize = 2.5f;
        float clamp = (float)size * 0.7f;
        float clampScaled = clamp * 0.005f;
        minecraft.func_110434_K().func_110577_a(base);
        RenderRadarScreen.renderBase(marginX, marginY, size, zLevel);
        RenderRadarScreen.renderComapss(marginX, marginY, size, zLevel, compassSize, clampScaled);
        if (sufficient) {
            RenderRadarScreen.renderBlips(marginX, marginY, size, zLevel, blipSize, clampScaled, range);
        } else {
            minecraft.func_110434_K().func_110577_a(error);
            RenderRadarScreen.renderBase(marginX, marginY, size, zLevel);
        }
        if (zoom) {
            minecraft.func_110434_K().func_110577_a(combat);
            RenderRadarScreen.renderBase(marginX, marginY, size, zLevel);
        }
        minecraft.field_71466_p.func_78276_b("" + blips.size(), marginX, marginY, 0xBBFFBB);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderBase(int marginX, int marginY, int size, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(marginX + 0), (double)(marginY + size), zLevel, 0.0, 1.0);
        tessellator.func_78374_a((double)(marginX + size), (double)(marginY + size), zLevel, 1.0, 1.0);
        tessellator.func_78374_a((double)(marginX + size), (double)(marginY + 0), zLevel, 1.0, 0.0);
        tessellator.func_78374_a((double)(marginX + 0), (double)(marginY + 0), zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void renderBlips(int marginX, int marginY, int size, double zLevel, float blipSize, float clamp, int range) {
        float z;
        float x;
        int cX = marginX + size / 2;
        int cY = marginY + size / 2;
        clamp = clamp * 75.0f / (float)range;
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft minecraft = Minecraft.func_71410_x();
        for (Blip blip : blips) {
            Vec3 vec = Vec3.func_72443_a((double)blip.x, (double)0.0, (double)blip.z);
            vec.func_72442_b((float)Math.toRadians(minecraft.field_71439_g.field_70177_z));
            x = blip.x * clamp * blip.x * clamp;
            z = blip.z * clamp * blip.z * clamp;
            if (Math.sqrt(x + z) > (double)size * 0.35) continue;
            x = (float)vec.field_72450_a;
            z = (float)vec.field_72449_c;
            switch (blip.type) {
                case 0: {
                    minecraft.func_110434_K().func_110577_a(blipGreen);
                    break;
                }
                case 1: {
                    minecraft.func_110434_K().func_110577_a(blipCircle);
                    break;
                }
                case 2: {
                    minecraft.func_110434_K().func_110577_a(blipX);
                    break;
                }
                case 3: {
                    minecraft.func_110434_K().func_110577_a(blipRed);
                    break;
                }
                case 4: {
                    minecraft.func_110434_K().func_110577_a(blipDanger);
                    break;
                }
                case 5: {
                    minecraft.func_110434_K().func_110577_a(blipUnknown);
                    break;
                }
                case 6: {
                    minecraft.func_110434_K().func_110577_a(blipMissileUp);
                    break;
                }
                case 7: {
                    minecraft.func_110434_K().func_110577_a(blipMissileDown);
                    break;
                }
                case 8: {
                    minecraft.func_110434_K().func_110577_a(blipAB);
                }
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)((float)cX + x * clamp - blipSize), (double)((float)cY + z * clamp + blipSize), zLevel, 0.0, 1.0);
            tessellator.func_78374_a((double)((float)cX + x * clamp + blipSize), (double)((float)cY + z * clamp + blipSize), zLevel, 1.0, 1.0);
            tessellator.func_78374_a((double)((float)cX + x * clamp + blipSize), (double)((float)cY + z * clamp - blipSize), zLevel, 1.0, 0.0);
            tessellator.func_78374_a((double)((float)cX + x * clamp - blipSize), (double)((float)cY + z * clamp - blipSize), zLevel, 0.0, 0.0);
            tessellator.func_78381_a();
        }
        float fontScale = 2.0f / scale;
        GL11.glScalef((float)(1.0f / fontScale), (float)(1.0f / fontScale), (float)(1.0f / fontScale));
        for (Blip blip : blips) {
            x = blip.x * clamp * blip.x * clamp;
            z = blip.z * clamp * blip.z * clamp;
            if (Math.sqrt(x + z) > (double)size * 0.35) continue;
            Vec3 vec = Vec3.func_72443_a((double)blip.x, (double)0.0, (double)blip.z);
            vec.func_72442_b((float)Math.toRadians(minecraft.field_71439_g.field_70177_z));
            x = (float)vec.field_72450_a;
            z = (float)vec.field_72449_c;
            if (blip.type != 3) {
                minecraft.field_71466_p.func_78276_b("" + Math.round(blip.y), (int)((float)cX * fontScale + (float)((int)(x * clamp * fontScale)) - 6.0f), (int)((float)cY * fontScale + (float)((int)(z * clamp * fontScale)) + 4.0f), 0xBBFFBB);
                continue;
            }
            minecraft.field_71466_p.func_78276_b("" + Math.round(blip.posX), (int)((float)cX * fontScale + (float)((int)(x * clamp * fontScale)) - 12.0f), (int)((float)cY * fontScale + (float)((int)(z * clamp * fontScale)) + 4.0f), 0xFFBBBB);
            minecraft.field_71466_p.func_78276_b("" + Math.round(blip.posZ), (int)((float)cX * fontScale + (float)((int)(x * clamp * fontScale)) - 12.0f), (int)((float)cY * fontScale + (float)((int)(z * clamp * fontScale)) + 12.0f), 0xFFBBBB);
        }
        GL11.glScalef((float)fontScale, (float)fontScale, (float)fontScale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderComapss(int marginX, int marginY, int size, double zLevel, float blipSize, float clamp) {
        int cX = marginX + size / 2;
        int cY = marginY + size / 2;
        blipSize *= scale;
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft minecraft = Minecraft.func_71410_x();
        float rotation = (float)((double)(minecraft.field_71439_g.field_70177_z - 90.0f) * Math.PI / 180.0);
        Vec3 vec = Vec3.func_72443_a((double)(clamp * 125.0f), (double)0.0, (double)0.0);
        vec.func_72446_c(rotation);
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                minecraft.func_110434_K().func_110577_a(north);
            }
            if (i == 1) {
                minecraft.func_110434_K().func_110577_a(west);
            }
            if (i == 2) {
                minecraft.func_110434_K().func_110577_a(south);
            }
            if (i == 3) {
                minecraft.func_110434_K().func_110577_a(east);
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)cX + vec.field_72450_a - (double)blipSize, (double)cY + vec.field_72448_b + (double)blipSize, zLevel, 0.0, 1.0);
            tessellator.func_78374_a((double)cX + vec.field_72450_a + (double)blipSize, (double)cY + vec.field_72448_b + (double)blipSize, zLevel, 1.0, 1.0);
            tessellator.func_78374_a((double)cX + vec.field_72450_a + (double)blipSize, (double)cY + vec.field_72448_b - (double)blipSize, zLevel, 1.0, 0.0);
            tessellator.func_78374_a((double)cX + vec.field_72450_a - (double)blipSize, (double)cY + vec.field_72448_b - (double)blipSize, zLevel, 0.0, 0.0);
            tessellator.func_78381_a();
            vec.func_72446_c(1.5707964f);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        scale = 1.0f;
    }

    public static class Blip {
        public float x;
        public float y;
        public float z;
        public float posX;
        public float posZ;
        public int type;

        public Blip(float x, float y, float z, float posX, float posZ, int type) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.posX = posX;
            this.posZ = posZ;
            this.type = type;
        }
    }
}

