/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.render.tileentity;

import com.hfr.tileentity.machine.TileEntityDisplay;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

public class RenderDisplay
extends TileEntitySpecialRenderer {
    public static ResourceLocation texture = new ResourceLocation("hfr:textures/models/display.png");

    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        float pixel = 0.0625f;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        switch (te.func_145832_p()) {
            case 2: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)(0.5 - (double)pixel));
        GL11.glDisable((int)2896);
        TileEntityDisplay display = (TileEntityDisplay)te;
        GL11.glTranslated((double)(pixel * -81.0f), (double)0.0, (double)0.0);
        Tessellator tessellator = Tessellator.field_78398_a;
        this.func_147499_a(texture);
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)(pixel * 54.0f), 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)(pixel * 162.0f), (double)(pixel * 54.0f), 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)(pixel * 162.0f), 0.0, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 1.0, 1.0);
        tessellator.func_78381_a();
        if (display.stock == null) {
            GL11.glPopMatrix();
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        float[] vals = display.stock.value;
        float[] render = new float[15];
        List<Float> floats = Arrays.asList(ArrayUtils.toObject((float[])vals));
        float min = Collections.min(floats).floatValue();
        float max = Collections.max(floats).floatValue();
        int padding = 5;
        int range = 52 - padding * 2;
        float d = max - min;
        if (d == 0.0f) {
            d = 1.0f;
        }
        for (int i = 0; i < render.length; ++i) {
            render[i] = (vals[i] - min) * (float)range / d;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
        GL11.glScalef((float)(-pixel), (float)(-pixel), (float)(-pixel));
        GL11.glTranslated((double)-168.5, (double)-81.0, (double)1.0);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)3.0f);
        float last = render[0];
        for (int i = 1; i < render.length; ++i) {
            tessellator.func_78371_b(3);
            tessellator.func_78378_d(0xFFFFFF);
            tessellator.func_78377_a((double)(8 + 10 * (i - 1)), (double)(88.0f - last - (float)padding), 0.0);
            tessellator.func_78377_a((double)(8 + 10 * (i - 1) + 10), (double)(88.0f - render[i] - (float)padding), 0.0);
            tessellator.func_78381_a();
            last = render[i];
        }
        GL11.glEnable((int)3553);
        float fontScale = 2.0f;
        GL11.glScalef((float)(1.0f / fontScale), (float)(1.0f / fontScale), (float)(1.0f / fontScale));
        String name = display.stock.name + " (" + display.stock.shortname + ")";
        minecraft.field_71466_p.func_78276_b("" + this.round(max), (int)(9.0f * fontScale), (int)(37.0f * fontScale), 0xFFFFFF);
        minecraft.field_71466_p.func_78276_b("" + name, (int)((float)(120 - minecraft.field_71466_p.func_78256_a(name) / 2) * fontScale), (int)(36.0f * fontScale), 0xFFFFFF);
        minecraft.field_71466_p.func_78276_b("" + this.round(min), (int)(9.0f * fontScale), (int)(83.5 * (double)fontScale), 0xFFFFFF);
        float diff = (vals[14] - vals[13]) / vals[13] * 100.0f;
        int color = 0xFF0000;
        if (diff > 0.0f) {
            color = 65280;
        }
        if (diff == 0.0f) {
            color = 0xFFFF00;
        }
        minecraft.field_71466_p.func_78276_b((diff >= 0.0f ? "+" : "") + this.round(diff) + "%", (int)(149.5 * (double)fontScale), (int)(38.5 * (double)fontScale), color);
        minecraft.field_71466_p.func_78276_b("=" + this.round(vals[14]), (int)(149.5 * (double)fontScale), (int)(48.5 * (double)fontScale), 0xFFFFFF);
        GL11.glScalef((float)fontScale, (float)fontScale, (float)fontScale);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public float round(float f) {
        f *= 100.0f;
        f = (int)f;
        return f /= 100.0f;
    }
}

