/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.schematic;

import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;

public class Schematic {
    private static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();
    public short[][][] blocks;
    public byte[][][] metadata;
    public int width;
    public int height;
    public int length;
    public String name = "";
    public int value = 1;

    public Schematic(int width, int height, int length) {
        this.blocks = new short[width][height][length];
        this.metadata = new byte[width][height][length];
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public boolean setBlock(int x, int y, int z, Block block, int metadata) {
        if (!this.isValid(x, y, z)) {
            return false;
        }
        int id = BLOCK_REGISTRY.getId((Object)block);
        if (id == -1) {
            return false;
        }
        this.blocks[x][y][z] = (short)id;
        this.setBlockMetadata(x, y, z, metadata);
        return true;
    }

    public boolean setBlockMetadata(int x, int y, int z, int metadata) {
        if (!this.isValid(x, y, z)) {
            return false;
        }
        this.metadata[x][y][z] = (byte)(metadata & 0xF);
        return true;
    }

    private boolean isValid(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.width && y < this.height && z < this.length;
    }
}

