/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.schematic;

import com.hfr.schematic.Schematic;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class SchematicLoader {
    private static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();

    public static Schematic readFromFile(File file) {
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            Schematic schem = SchematicLoader.readFromNBT(nbt);
            schem.name = file.getName().replace(".schematic", "").split("_")[0];
            return schem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Schematic readFromNBT(NBTTagCompound tagCompound) {
        byte[] localBlocks = tagCompound.func_74770_j("Blocks");
        byte[] localMetadata = tagCompound.func_74770_j("Data");
        boolean extra = false;
        byte[] extraBlocks = null;
        byte[] extraBlocksNibble = null;
        if (tagCompound.func_74764_b("AddBlocks")) {
            extra = true;
            extraBlocksNibble = tagCompound.func_74770_j("AddBlocks");
            extraBlocks = new byte[extraBlocksNibble.length * 2];
            for (int i = 0; i < extraBlocksNibble.length; ++i) {
                extraBlocks[i * 2 + 0] = (byte)(extraBlocksNibble[i] >> 4 & 0xF);
                extraBlocks[i * 2 + 1] = (byte)(extraBlocksNibble[i] & 0xF);
            }
        } else if (tagCompound.func_74764_b("Add")) {
            extra = true;
            extraBlocks = tagCompound.func_74770_j("Add");
        }
        int width = tagCompound.func_74765_d("Width");
        int length = tagCompound.func_74765_d("Length");
        int height = tagCompound.func_74765_d("Height");
        Short id = null;
        HashMap<Short, Short> oldToNew = new HashMap<Short, Short>();
        if (tagCompound.func_74764_b("SchematicaMapping")) {
            NBTTagCompound mapping = tagCompound.func_74775_l("SchematicaMapping");
            Set names = mapping.func_150296_c();
            for (String name : names) {
                oldToNew.put(mapping.func_74765_d(name), (short)BLOCK_REGISTRY.getId(name));
            }
        }
        Schematic schematic = new Schematic(width, height, length);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = x + (y * length + z) * width;
                    int blockID = localBlocks[index] & 0xFF | (extra ? (extraBlocks[index] & 0xFF) << 8 : 0);
                    int meta = localMetadata[index] & 0xFF;
                    id = (Short)oldToNew.get((short)blockID);
                    if (id != null) {
                        blockID = id.shortValue();
                    }
                    schematic.setBlock(x, y, z, (Block)BLOCK_REGISTRY.func_148754_a(blockID), meta);
                }
            }
        }
        return schematic;
    }
}

