/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.schematic;

import com.hfr.schematic.Schematic;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;

public class SchematicPayload {
    private static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();
    public short[] blocks;
    public byte[] metas;
    public short width;
    public short height;
    public short length;

    public SchematicPayload(Schematic schem) {
        int count = schem.width * schem.height * schem.length;
        this.width = (short)schem.width;
        this.height = (short)schem.height;
        this.length = (short)schem.length;
        this.blocks = new short[count];
        this.metas = new byte[count];
        this.serialize(schem);
    }

    public SchematicPayload(ByteBuf buf) {
        this.fromBytes(buf);
    }

    private void serialize(Schematic schem) {
        for (int dx = 0; dx < schem.width; ++dx) {
            for (int dy = 0; dy < schem.height; ++dy) {
                for (int dz = 0; dz < schem.length; ++dz) {
                    short b = schem.blocks[dx][dy][dz];
                    byte meta = schem.metadata[dx][dy][dz];
                    int index = dx * schem.height * schem.length + dy * schem.length + dz;
                    this.blocks[index] = b;
                    this.metas[index] = meta;
                }
            }
        }
    }

    public Schematic deserialize() {
        Schematic schem = new Schematic(this.width, this.height, this.length);
        for (int i = 0; i < this.blocks.length; ++i) {
            int z = i % this.length;
            int y = i / this.length % this.height;
            int x = i / this.length / this.height % this.width;
            schem.blocks[x][y][z] = this.blocks[i];
            schem.metadata[x][y][z] = this.metas[i];
        }
        return schem;
    }

    public void fromBytes(ByteBuf buf) {
        int count = buf.readInt();
        this.width = buf.readShort();
        this.height = buf.readShort();
        this.length = buf.readShort();
        this.blocks = new short[count];
        this.metas = new byte[count];
        for (int i = 0; i < count; ++i) {
            this.blocks[i] = buf.readShort();
            this.metas[i] = buf.readByte();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blocks.length);
        buf.writeShort((int)this.width);
        buf.writeShort((int)this.height);
        buf.writeShort((int)this.length);
        for (int i = 0; i < this.blocks.length; ++i) {
            buf.writeShort((int)this.blocks[i]);
            buf.writeByte((int)this.metas[i]);
        }
    }
}

