/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.clowder;

import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.data.ClowderData;
import com.hfr.items.ModItems;
import com.hfr.tileentity.clowder.ITerritoryProvider;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityCap
extends TileEntityMachineBase
implements ITerritoryProvider {
    public Clowder owner;
    public int progress;
    public static final int maxProgress = 200;
    public String name = "";
    @SideOnly(value=Side.CLIENT)
    public int color;

    public TileEntityCap() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.capPoint";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (Clowder.clowders.size() == 0) {
                ClowderData.getData(this.field_145850_b);
            }
            if (!Clowder.clowders.contains(this.owner)) {
                this.owner = null;
            }
            List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 5)));
            Clowder capturer = null;
            for (EntityPlayer player : entities) {
                Clowder clow = Clowder.getClowderFromPlayer(player);
                if (clow == null || !player.field_71071_by.func_146028_b(ModItems.mace)) continue;
                capturer = clow;
                break;
            }
            if (capturer != null && capturer != this.owner && this.canSeeSky() && (this.owner == null || this.owner.isRaidable())) {
                if (this.progress == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:block.flagCapture", 100.0f, 1.0f);
                    if (this.owner != null) {
                        this.owner.notifyCapture(this.field_145850_b, this.field_145851_c, this.field_145849_e, "control points");
                    }
                }
                ++this.progress;
                if (this.progress >= 200) {
                    this.owner = capturer;
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:block.flagHoist", 3.0f, 1.0f);
                    this.generateClaim();
                }
            } else {
                this.progress = 0;
            }
            if (this.progress == 0 && this.owner != null && this.field_145850_b.field_73012_v.nextInt(100) == 0) {
                for (int i = 0; i < this.slots.length; ++i) {
                    if (this.slots[i] == null) {
                        this.slots[i] = new ItemStack(ModItems.province_point);
                        break;
                    }
                    if (this.slots[i].func_77973_b() != ModItems.province_point || this.slots[i].field_77994_a >= 64) continue;
                    ++this.slots[i].field_77994_a;
                    break;
                }
            }
            if (!this.canSeeSky()) {
                this.progress = 0;
                this.owner = null;
            } else if (this.owner != null) {
                // empty if block
            }
            if (this.owner != null) {
                this.updateGauge(this.owner.color, 0, 100);
            } else {
                this.updateGauge(0xFFFFFF, 0, 100);
            }
        }
    }

    @Override
    public int getRadius() {
        return 20;
    }

    @Override
    public Clowder getOwner() {
        return this.owner;
    }

    public void generateClaim() {
        int rad = this.getRadius();
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                int posX = this.field_145851_c + x * 16;
                int posZ = this.field_145849_e + z * 16;
                ClowderTerritory.CoordPair loc = ClowderTerritory.getCoordPair(posX, posZ);
                ClowderTerritory.TerritoryMeta meta = ClowderTerritory.getMetaFromCoords(loc);
                if (meta != null && meta.checkPersistence(this.field_145850_b, loc) || !(Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0)) < (double)rad)) continue;
                ClowderTerritory.setOwnerForCoord(this.field_145850_b, loc, this.owner, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.name);
            }
        }
    }

    public boolean canSeeSky() {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if ((this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + j).func_149688_o() == Material.field_151579_a || i == 0 && j == 0) && this.field_145850_b.func_72937_j(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + j)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void processGauge(int val, int id) {
        if (id == 0) {
            this.color = val;
        }
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1, 2, 3, 4};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.owner = Clowder.getClowderFromName(nbt.func_74779_i("owner"));
        this.progress = nbt.func_74762_e("progress");
        this.name = nbt.func_74779_i("name");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
        if (this.owner != null) {
            this.generateClaim();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner != null) {
            nbt.func_74778_a("owner", this.owner.name);
        }
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74778_a("name", this.name);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public String getClaimName() {
        return this.name;
    }

    @Override
    public void setClaimName(String name) {
        this.name = name;
    }
}

