/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.clowder;

import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderFlag;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.main.MainRegistry;
import com.hfr.tileentity.clowder.ITerritoryProvider;
import com.hfr.tileentity.clowder.TileEntityFlag;
import com.hfr.tileentity.clowder.TileEntityFlagBig;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityConquerer
extends TileEntityMachineBase
implements ITerritoryProvider {
    public Clowder owner;
    public float height = 0.0f;
    public static final float speed = 0.00125f;
    public String name = "";
    @SideOnly(value=Side.CLIENT)
    public ClowderFlag flag;
    @SideOnly(value=Side.CLIENT)
    public int color;

    public TileEntityConquerer() {
        super(0);
    }

    @Override
    public String getName() {
        return "undefined";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!Clowder.clowders.contains(this.owner) && this.owner != null) {
                MainRegistry.logger.info("Deleting clowder from conquerer " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " due to clowder not being in the clowder list! (disband?)");
                this.owner = null;
                return;
            }
            if (this.owner == null) {
                this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                return;
            }
            int range = 32;
            List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - (double)range), (double)(this.field_145848_d - 2), (double)((double)this.field_145849_e + 0.5 - (double)range), (double)((double)this.field_145851_c + 0.5 + (double)range), (double)(this.field_145848_d + 4), (double)((double)this.field_145849_e + 0.5 + (double)range)));
            boolean canRaise = false;
            for (EntityPlayer player : entities) {
                Clowder clow = Clowder.getClowderFromPlayer(player);
                if (clow == null || clow != this.owner) continue;
                canRaise = true;
            }
            double prev = this.height;
            if (!canRaise && this.height < 1.0f) {
                this.height -= 0.00125f;
            } else if (this.height < 1.0f) {
                this.height += 0.00125f;
            }
            if (this.height < 0.0f) {
                this.height = 0.0f;
            }
            if (this.height > 1.0f) {
                this.height = 1.0f;
            }
            if (this.height >= 1.0f && prev < 1.0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:block.flagCapture", 100.0f, 1.0f);
                this.conquer();
            }
            this.updateGauge(this.owner.flag.ordinal(), 0, 250);
            this.updateGauge(this.owner.color, 1, 250);
            this.updateGauge((int)(this.height * 100.0f), 2, 100);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.flag = ClowderFlag.values()[val];
                break;
            }
            case 1: {
                this.color = val;
                break;
            }
            case 2: {
                this.height = (float)val * 0.01f;
            }
        }
    }

    public boolean canSeeSky() {
        return this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void conquer() {
        ClowderTerritory.CoordPair loc = ClowderTerritory.getCoordPair(this.field_145851_c, this.field_145849_e);
        ClowderTerritory.TerritoryMeta meta = ClowderTerritory.getMetaFromCoords(loc);
        if (meta != null && meta.owner.zone == ClowderTerritory.Zone.FACTION && meta.owner.owner != this.owner) {
            ClowderTerritory.CoordPair loc2 = ClowderTerritory.getCoordPair(meta.flagX, meta.flagZ);
            TileEntity te = this.field_145850_b.func_147438_o(meta.flagX, meta.flagY, meta.flagZ);
            if (loc.equals(loc2)) {
                if (te instanceof TileEntityFlagBig) {
                    ((TileEntityFlagBig)te).owner = this.owner;
                    ((TileEntityFlagBig)te).generateClaim();
                    te.func_70296_d();
                    this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                } else if (te instanceof TileEntityFlag) {
                    ((TileEntityFlag)te).setOwner(this.owner);
                    this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                } else if (te instanceof TileEntityConquerer) {
                    this.field_145850_b.func_147480_a(meta.flagX, meta.flagY, meta.flagZ, false);
                    ClowderTerritory.setOwnerForCoord(this.field_145850_b, loc, this.owner, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.name);
                }
            } else {
                ClowderTerritory.setOwnerForCoord(this.field_145850_b, loc, this.owner, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.name);
            }
        } else {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
    }

    public boolean checkBorder(int x, int z) {
        ClowderTerritory.CoordPair loc = ClowderTerritory.getCoordPair(x, z);
        ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromCoords(loc);
        if (owner.zone != ClowderTerritory.Zone.FACTION || owner.owner == this.owner) {
            return false;
        }
        ClowderTerritory.CoordPair loc1 = ClowderTerritory.getCoordPair(x + 16, z);
        ClowderTerritory.Ownership owner1 = ClowderTerritory.getOwnerFromCoords(loc1);
        if (owner1.zone == ClowderTerritory.Zone.WILDERNESS || owner1.owner != owner.owner) {
            return true;
        }
        ClowderTerritory.CoordPair loc2 = ClowderTerritory.getCoordPair(x - 16, z);
        ClowderTerritory.Ownership owner2 = ClowderTerritory.getOwnerFromCoords(loc2);
        if (owner2.zone == ClowderTerritory.Zone.WILDERNESS || owner2.owner != owner.owner) {
            return true;
        }
        ClowderTerritory.CoordPair loc3 = ClowderTerritory.getCoordPair(x, z + 16);
        ClowderTerritory.Ownership owner3 = ClowderTerritory.getOwnerFromCoords(loc3);
        if (owner3.zone == ClowderTerritory.Zone.WILDERNESS || owner3.owner != owner.owner) {
            return true;
        }
        ClowderTerritory.CoordPair loc4 = ClowderTerritory.getCoordPair(x, z - 16);
        ClowderTerritory.Ownership owner4 = ClowderTerritory.getOwnerFromCoords(loc4);
        return owner4.zone == ClowderTerritory.Zone.WILDERNESS || owner4.owner != owner.owner;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        String own = nbt.func_74779_i("owner");
        this.owner = Clowder.getClowderFromName(own);
        boolean isNull = nbt.func_74767_n("isNull");
        if (this.owner == null) {
            String id = nbt.func_74779_i("clow_uuid");
            this.owner = Clowder.getClowderFromUUID(id);
            if (!isNull && this.owner == null) {
                MainRegistry.logger.info("Owner (" + id + ") of flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " was saved NN but finalized as null!");
            }
            if (this.owner == null && !id.isEmpty()) {
                MainRegistry.logger.info("Owner (" + id + ") of flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " was set in NBT but not found in te clowder list!");
            }
        }
        this.height = nbt.func_74760_g("height");
        this.name = nbt.func_74779_i("name");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner != null) {
            nbt.func_74757_a("isNull", false);
            nbt.func_74778_a("clow_uuid", this.owner.uuid);
        } else {
            nbt.func_74757_a("isNull", true);
        }
        nbt.func_74776_a("height", this.height);
        nbt.func_74778_a("name", this.name);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public int getRadius() {
        return 0;
    }

    @Override
    public Clowder getOwner() {
        return this.owner;
    }

    @Override
    public String getClaimName() {
        return this.name;
    }

    @Override
    public void setClaimName(String name) {
        this.name = name;
    }
}

