/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.clowder;

import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderFlag;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.items.ModItems;
import com.hfr.main.MainRegistry;
import com.hfr.tileentity.clowder.ITerritoryProvider;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFlag
extends TileEntityMachineBase
implements ITerritoryProvider {
    public Clowder owner;
    public boolean isClaimed = true;
    public float height = 1.0f;
    public float speed = 0.0016666667f;
    public int mode = 0;
    public String name = "";
    private int timer = 0;
    @SideOnly(value=Side.CLIENT)
    public ClowderFlag flag;
    @SideOnly(value=Side.CLIENT)
    public int color;
    @SideOnly(value=Side.CLIENT)
    public float prestige;
    @SideOnly(value=Side.CLIENT)
    public float prestigeReq;

    public TileEntityFlag() {
        super(0);
    }

    @Override
    public String getName() {
        return "container.flagPole";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!Clowder.clowders.contains(this.owner) && this.owner != null) {
                MainRegistry.logger.info("Deleting clowder from flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " due to clowder not being in the clowder list! (disband?)");
                this.owner = null;
            }
            float prev = this.height;
            Clowder prevC = this.owner;
            if (!this.isClaimed && this.canSeeSky()) {
                List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 5)));
                Clowder capturer = null;
                for (EntityPlayer player : entities) {
                    Clowder clow = Clowder.getClowderFromPlayer(player);
                    if (clow == null) continue;
                    capturer = clow;
                    break;
                }
                if (capturer != null) {
                    if (capturer == this.owner) {
                        this.height += this.speed;
                        if (this.height >= 1.0f) {
                            MainRegistry.logger.info("Locking flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " for being hoisted! (captured and raised!)");
                            this.isClaimed = true;
                            this.height = 1.0f;
                            this.func_70296_d();
                        }
                    } else {
                        this.height -= this.speed;
                        if (this.height <= 0.0f) {
                            this.setOwner(capturer);
                            this.height = 0.0f;
                            this.func_70296_d();
                        }
                    }
                } else {
                    this.height -= this.speed;
                    if (this.height <= 0.0f) {
                        this.height = 0.0f;
                    }
                }
            }
            if (!this.isClaimed || this.owner == null) {
                this.setMode(0);
                this.timer = 0;
                this.func_70296_d();
            } else {
                if (this.timer > 0) {
                    --this.timer;
                }
                if (this.mode > 0 && this.timer <= 0) {
                    if (this.consumeToken()) {
                        this.timer = this.getTime();
                    } else {
                        this.setMode(0);
                        this.timer = 0;
                    }
                    this.func_70296_d();
                }
            }
            if (prev == 1.0f && this.height != 1.0f) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:block.flagCapture", 100.0f, 1.0f);
                MainRegistry.logger.info("Unlocking flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " for being unhoisted! (captured!)");
                if (this.owner != null) {
                    this.owner.notifyCapture(this.field_145850_b, this.field_145851_c, this.field_145849_e, "flags");
                }
            }
            if (prevC != this.owner) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:block.flagChange", 3.0f, 1.0f);
            }
            if (prev != 1.0f && this.height == 1.0f) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:block.flagHoist", 3.0f, 1.0f);
                MainRegistry.logger.info("Hoisintg flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + "!");
                this.generateClaim();
            }
            if (!this.canSeeSky()) {
                if (this.isClaimed) {
                    MainRegistry.logger.info("Unlocking flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " for being obstructed!");
                }
                this.isClaimed = false;
                this.setOwner(null);
                if (this.height >= this.speed * 2.0f) {
                    this.height -= this.speed * 2.0f;
                }
            } else if (this.owner != null) {
                // empty if block
            }
            if (this.owner != null) {
                this.updateGauge(this.owner.flag.ordinal(), 0, 250);
                this.updateGauge(this.owner.color, 1, 250);
                this.updateGauge(Float.floatToIntBits(this.owner.getPrestige()), 4, 20);
                this.updateGauge(Float.floatToIntBits(this.owner.getPrestigeReq()), 5, 20);
            } else {
                this.updateGauge(ClowderFlag.NONE.ordinal(), 0, 250);
                this.updateGauge(0xFFFFFF, 1, 250);
                this.updateGauge(0, 4, 20);
                this.updateGauge(0, 5, 20);
            }
            this.updateGauge(this.mode, 2, 25);
            this.updateGauge((int)(this.height * 100.0f), 3, 100);
        } else if (this.mode > 0) {
            double x = (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
            double y = (double)this.field_145848_d + 0.125 + this.field_145850_b.field_73012_v.nextDouble() * 0.5;
            double z = (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
            float r = Math.max((float)((this.color & 0xFF0000) >> 16) / 256.0f, 0.01f);
            float g = Math.max((float)((this.color & 0xFF00) >> 8) / 256.0f, 0.01f);
            float b = Math.max((float)(this.color & 0xFF) / 256.0f, 0.01f);
            this.field_145850_b.func_72869_a("reddust", x, y, z, (double)r, (double)g, (double)b);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.flag = ClowderFlag.values()[val];
                break;
            }
            case 1: {
                this.color = val;
                break;
            }
            case 2: {
                this.mode = val;
                break;
            }
            case 3: {
                this.height = (float)val * 0.01f;
                break;
            }
            case 4: {
                this.prestige = Float.intBitsToFloat(val);
                break;
            }
            case 5: {
                this.prestigeReq = Float.intBitsToFloat(val);
            }
        }
    }

    public float getGenRate() {
        return TileEntityFlag.getGenRateFromMode(this.mode);
    }

    public static float getGenRateFromMode(int mode) {
        if (mode != 0) {
            return 0.1f;
        }
        return 0.0f;
    }

    public float getCost() {
        return TileEntityFlag.getCostFromMode(this.mode);
    }

    public static float getCostFromMode(int mode) {
        if (mode == 1) {
            return 3.0f;
        }
        if (mode == 2) {
            return 2.0f;
        }
        if (mode == 3) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void setOwner(Clowder c) {
        if (this.owner != c) {
            MainRegistry.logger.info("Changing owner for flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " from " + (this.owner != null ? this.owner.name : "null") + " to " + (c != null ? c.name : "null"));
        }
        if (this.owner != null) {
            this.owner.addPrestigeGen(-this.getGenRate(), this.field_145850_b);
            this.owner.addPrestigeReq(-this.getCost(), this.field_145850_b);
            --this.owner.flags;
            this.owner.multPrestige(0.95f, this.field_145850_b);
        }
        this.owner = c;
        if (this.owner != null) {
            this.owner.addPrestigeGen(this.getGenRate(), this.field_145850_b);
            this.owner.addPrestigeReq(this.getCost(), this.field_145850_b);
            ++this.owner.flags;
        }
        this.func_70296_d();
    }

    public void setMode(int mode) {
        if (this.owner == null) {
            this.mode = 0;
            return;
        }
        float beforeGen = TileEntityFlag.getGenRateFromMode(this.mode);
        float afterGen = TileEntityFlag.getGenRateFromMode(mode);
        float beforeCost = TileEntityFlag.getCostFromMode(this.mode);
        float afterCost = TileEntityFlag.getCostFromMode(mode);
        if (this.owner.getPrestigeReq() - beforeCost + afterCost > this.owner.getPrestige()) {
            return;
        }
        this.owner.addPrestigeGen(-beforeGen, this.field_145850_b);
        this.owner.addPrestigeReq(-beforeCost, this.field_145850_b);
        this.mode = mode;
        this.owner.addPrestigeGen(afterGen, this.field_145850_b);
        this.owner.addPrestigeReq(afterCost, this.field_145850_b);
        this.func_70296_d();
    }

    private boolean consumeToken() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.province_point) continue;
            this.func_70298_a(i, 1);
            return true;
        }
        return true;
    }

    private int getTime() {
        switch (this.mode) {
            case 1: {
                return 200;
            }
            case 2: {
                return 500;
            }
            case 3: {
                return 1000;
            }
        }
        return 0;
    }

    @Override
    public int getRadius() {
        switch (this.mode) {
            case 1: {
                return 10;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public Clowder getOwner() {
        return this.owner;
    }

    public void generateClaim() {
        int rad = this.getRadius();
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                int posX = this.field_145851_c + x * 16;
                int posZ = this.field_145849_e + z * 16;
                ClowderTerritory.CoordPair loc = ClowderTerritory.getCoordPair(posX, posZ);
                ClowderTerritory.TerritoryMeta meta = ClowderTerritory.getMetaFromCoords(loc);
                if (meta != null && meta.checkPersistence(this.field_145850_b, loc) || !(Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0)) < (double)rad)) continue;
                ClowderTerritory.setOwnerForCoord(this.field_145850_b, loc, this.owner, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.name);
            }
        }
    }

    public boolean bordersWilderness() {
        return true;
    }

    public boolean checkBorder(int x, int z) {
        ClowderTerritory.CoordPair loc = ClowderTerritory.getCoordPair(x, z);
        ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromCoords(loc);
        if (owner.zone != ClowderTerritory.Zone.FACTION || owner.owner != this.owner) {
            return false;
        }
        ClowderTerritory.CoordPair loc1 = ClowderTerritory.getCoordPair(x + 16, z);
        ClowderTerritory.Ownership owner1 = ClowderTerritory.getOwnerFromCoords(loc1);
        if (owner1.zone == ClowderTerritory.Zone.WILDERNESS || owner1.owner != this.owner) {
            return true;
        }
        ClowderTerritory.CoordPair loc2 = ClowderTerritory.getCoordPair(x - 16, z);
        ClowderTerritory.Ownership owner2 = ClowderTerritory.getOwnerFromCoords(loc2);
        if (owner2.zone == ClowderTerritory.Zone.WILDERNESS || owner2.owner != this.owner) {
            return true;
        }
        ClowderTerritory.CoordPair loc3 = ClowderTerritory.getCoordPair(x, z + 16);
        ClowderTerritory.Ownership owner3 = ClowderTerritory.getOwnerFromCoords(loc3);
        if (owner3.zone == ClowderTerritory.Zone.WILDERNESS || owner3.owner != this.owner) {
            return true;
        }
        ClowderTerritory.CoordPair loc4 = ClowderTerritory.getCoordPair(x, z - 16);
        ClowderTerritory.Ownership owner4 = ClowderTerritory.getOwnerFromCoords(loc4);
        return owner4.zone == ClowderTerritory.Zone.WILDERNESS || owner4.owner != this.owner;
    }

    public boolean canSeeSky() {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (this.field_145850_b.func_72937_j(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + j) && this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d - 1, this.field_145849_e + j).isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c + i, this.field_145848_d - 1, this.field_145849_e + j, ForgeDirection.UP)) continue;
                return false;
            }
        }
        if (this.field_145848_d < 45) {
            return false;
        }
        return this.field_145848_d <= 100;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        String own = nbt.func_74779_i("owner");
        this.owner = Clowder.getClowderFromName(own);
        boolean isNull = nbt.func_74767_n("isNull");
        if (this.owner == null) {
            String id = nbt.func_74779_i("clow_uuid");
            this.owner = Clowder.getClowderFromUUID(id);
            if (!isNull && this.owner == null) {
                MainRegistry.logger.info("Owner (" + id + ") of flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " was saved NN but finalized as null!");
            }
            if (this.owner == null && !id.isEmpty()) {
                MainRegistry.logger.info("Owner (" + id + ") of flag " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " was set in NBT but not found in te clowder list!");
            }
        }
        this.isClaimed = nbt.func_74767_n("isClaimed");
        this.height = nbt.func_74760_g("height");
        this.mode = nbt.func_74762_e("mode");
        this.timer = nbt.func_74762_e("timer");
        this.name = nbt.func_74779_i("name");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner != null) {
            nbt.func_74757_a("isNull", false);
            nbt.func_74778_a("clow_uuid", this.owner.uuid);
        } else {
            nbt.func_74757_a("isNull", true);
        }
        nbt.func_74757_a("isClaimed", this.isClaimed);
        nbt.func_74776_a("height", this.height);
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74768_a("timer", this.timer);
        nbt.func_74778_a("name", this.name);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public String getClaimName() {
        return this.name;
    }

    @Override
    public void setClaimName(String name) {
        this.name = name;
    }
}

