/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.clowder;

import com.hfr.blocks.ModBlocks;
import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderFlag;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.clowder.events.RegionOwnershipChangedEvent;
import com.hfr.data.ClowderData;
import com.hfr.tileentity.clowder.ITerritoryProvider;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityFlagBig
extends TileEntityMachineBase
implements ITerritoryProvider {
    public Clowder owner;
    public boolean isClaimed = false;
    public boolean isCappable = true;
    public HashSet<ClowderTerritory.CoordPair> claim = new HashSet();
    public String name = "";
    @SideOnly(value=Side.CLIENT)
    public ClowderFlag flag;
    @SideOnly(value=Side.CLIENT)
    public int color;
    public String provinceName = "";

    public TileEntityFlagBig() {
        super(2);
    }

    public int getCost() {
        return this.claim.size() / 150 + 1;
    }

    @Override
    public String getName() {
        return "container.flagPole";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int claimCost = this.claim.size() / 150 + 1;
            if (Clowder.clowders.size() == 0) {
                ClowderData.getData(this.field_145850_b);
            }
            ClowderTerritory.CoordPair[] coords = this.claim.toArray(new ClowderTerritory.CoordPair[1]);
            coords = this.claim.toArray(coords);
            Random rng = new Random();
            if (this.claim == null || this.claim.isEmpty()) {
                return;
            }
            long sampleCode = ClowderTerritory.coordsToCode(coords[rng.nextInt(coords.length)]);
            ClowderTerritory.TerritoryMeta sampleMeta = ClowderTerritory.territories.get(sampleCode);
            if (sampleMeta == null) {
                return;
            }
            if (this.owner != null && !Clowder.clowders.contains(this.owner) || this.owner == null && sampleMeta.owner != null && sampleMeta.owner.zone == ClowderTerritory.Zone.FACTION) {
                this.owner = null;
                this.isCappable = false;
                for (ClowderTerritory.CoordPair a : this.claim) {
                    long code = ClowderTerritory.coordsToCode(a);
                    if (ClowderTerritory.territories.get(code) != null && ClowderTerritory.territories.get((Object)Long.valueOf((long)code)).owner.zone == ClowderTerritory.Zone.FACTION) {
                        ClowderTerritory.territories.get((Object)Long.valueOf((long)code)).owner = new ClowderTerritory.Ownership(ClowderTerritory.Zone.WILDERNESS);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new RegionOwnershipChangedEvent(null, new ClowderTerritory.Ownership(ClowderTerritory.Zone.WILDERNESS), this.provinceName));
                }
            }
            if (this.owner == null && this.isCappable) {
                List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 5)));
                Clowder capturer = null;
                for (EntityPlayer player : entities) {
                    Clowder clow = Clowder.getClowderFromPlayer(player);
                    if (clow == null) continue;
                    capturer = clow;
                    break;
                }
                if (capturer != null) {
                    ClowderTerritory.Ownership oldOwner = sampleMeta.owner;
                    this.owner = capturer;
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:block.flagChange", 3.0f, 1.0f);
                    this.isClaimed = true;
                    this.generateClaim();
                    MinecraftForge.EVENT_BUS.post((Event)new RegionOwnershipChangedEvent(oldOwner, sampleMeta.owner, this.provinceName));
                }
            } else if (this.slots[1] != null && this.field_145850_b.field_73012_v.nextInt(1200) == 0) {
                if (this.slots[0] == null) {
                    this.slots[0] = this.slots[1].func_77946_l();
                } else if (this.slots[0].func_77973_b() == this.slots[1].func_77973_b() && this.slots[0].field_77994_a < this.slots[0].func_77976_d()) {
                    ++this.slots[0].field_77994_a;
                }
            }
            if (this.owner != null) {
                this.updateGauge(this.owner.flag.ordinal(), 0, 100);
                this.updateGauge(this.owner.color, 1, 100);
            } else {
                this.updateGauge(ClowderFlag.NONE.ordinal(), 0, 100);
                this.updateGauge(0xFFFFFF, 1, 100);
            }
        } else {
            boolean bl = this.isClaimed = this.flag != ClowderFlag.NONE;
            if (this.isClaimed) {
                double x = (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5;
                double y = (double)this.field_145848_d + 0.125 + this.field_145850_b.field_73012_v.nextDouble() * 0.5;
                double z = (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5;
                float r = Math.max((float)((this.color & 0xFF0000) >> 16) / 256.0f, 0.01f);
                float g = Math.max((float)((this.color & 0xFF00) >> 8) / 256.0f, 0.01f);
                float b = Math.max((float)(this.color & 0xFF) / 256.0f, 0.01f);
                this.field_145850_b.func_72869_a("reddust", x, y, z, (double)r, (double)g, (double)b);
            }
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.flag = ClowderFlag.values()[val];
                break;
            }
            case 1: {
                this.color = val;
            }
        }
    }

    @Override
    public int getRadius() {
        return 1000;
    }

    @Override
    public Clowder getOwner() {
        return this.owner;
    }

    public void addClaim(int x1, int z1, int x2, int z2) {
        int minX = Math.min(x1, x2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxZ = Math.max(z1, z2);
        for (int x = minX; x <= maxX; x += 16) {
            for (int z = minZ; z <= maxZ; z += 16) {
                ClowderTerritory.CoordPair coord = ClowderTerritory.getCoordPair(x, z);
                this.claim.add(coord);
            }
        }
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:item.techBoop", 3.0f, 1.0f);
        this.func_70296_d();
        this.generateClaim();
    }

    public void generateClaim() {
        for (ClowderTerritory.CoordPair coords : this.claim) {
            int z;
            int y;
            int x;
            ClowderTerritory.TerritoryMeta meta = ClowderTerritory.getMetaFromCoords(coords);
            if (meta != null && meta.owner != null && meta.owner.zone == ClowderTerritory.Zone.FACTION && this.field_145850_b.func_147439_a(x = meta.flagX, y = meta.flagY, z = meta.flagZ) == ModBlocks.clowder_conquerer) {
                this.field_145850_b.func_147480_a(x, y, z, false);
            }
            if (this.owner != null) {
                ClowderTerritory.setOwnerForCoord(this.field_145850_b, coords, this.owner, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.provinceName);
                continue;
            }
            ClowderTerritory.removeZoneForCoord(this.field_145850_b, coords);
        }
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.owner = Clowder.getClowderFromName(nbt.func_74779_i("owner"));
        this.isClaimed = nbt.func_74767_n("isClaimed");
        this.name = nbt.func_74779_i("name");
        int length = nbt.func_74762_e("len");
        for (int i = 0; i < length; ++i) {
            this.claim.add(new ClowderTerritory.CoordPair(nbt.func_74762_e("x" + i), nbt.func_74762_e("z" + i)));
        }
        this.provinceName = nbt.func_74779_i("P");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner != null) {
            nbt.func_74778_a("owner", this.owner.name);
        }
        nbt.func_74757_a("isClaimed", this.isClaimed);
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("len", this.claim.size());
        int i = 0;
        for (ClowderTerritory.CoordPair coords : this.claim) {
            nbt.func_74768_a("x" + i, coords.x);
            nbt.func_74768_a("z" + i, coords.z);
            ++i;
        }
        nbt.func_74778_a("P", this.provinceName);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public String getClaimName() {
        return this.name;
    }

    @Override
    public void setClaimName(String name) {
        this.name = name;
    }
}

