/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import com.hfr.util.Location;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBattery
extends TileEntityMachineBase
implements IEnergyHandler {
    public EnergyStorage storage = new EnergyStorage(200000, 2000, 2000);

    public TileEntityBattery() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.battery";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            IEnergyContainerItem item;
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof IEnergyContainerItem) {
                item = (IEnergyContainerItem)this.slots[0].func_77973_b();
                int extract = Math.min(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), item.getEnergyStored(this.slots[0]));
                int e = item.extractEnergy(this.slots[0], extract, false);
                this.storage.setEnergyStored(this.storage.getEnergyStored() + e);
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IEnergyContainerItem) {
                item = (IEnergyContainerItem)this.slots[1].func_77973_b();
                int receive = Math.min(this.storage.getEnergyStored(), item.getMaxEnergyStored(this.slots[1]) - item.getEnergyStored(this.slots[1]));
                int r = item.receiveEnergy(this.slots[1], receive, false);
                this.storage.setEnergyStored(this.storage.getEnergyStored() - r);
            }
            if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Location loc = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).add(dir);
                    TileEntity entity = loc.getTileEntity();
                    if (entity == null || !(entity instanceof IEnergyReceiver)) continue;
                    IEnergyReceiver receiver = (IEnergyReceiver)entity;
                    int maxExtract = this.storage.getMaxExtract();
                    int maxAvailable = this.storage.extractEnergy(maxExtract, true);
                    int energyTransferred = receiver.receiveEnergy(dir.getOpposite(), maxAvailable, false);
                    this.storage.extractEnergy(energyTransferred, false);
                }
            }
            this.updateGauge(this.storage.getEnergyStored(), 0, 50);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        this.storage.setEnergyStored(val);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int getPowerScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }
}

