/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.hfr.main.MainRegistry;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import com.hfr.util.Location;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCoalGen
extends TileEntityMachineBase
implements IEnergyProvider {
    public EnergyStorage storage = new EnergyStorage(MainRegistry.coalgenProduction * 1000, MainRegistry.coalgenProduction * 10, MainRegistry.coalgenProduction * 10);
    public int burnTime = 0;
    int[] access = new int[]{0};

    public TileEntityCoalGen() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.coalGen";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.storage.setEnergyStored(this.storage.getEnergyStored() + MainRegistry.coalgenProduction);
            }
            if (this.burnTime == 0 && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored() && this.slots[0] != null && TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]) > 0) {
                this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]);
                this.func_70298_a(0, 1);
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)this.slots[1].func_77973_b();
                int receive = Math.min(this.storage.getEnergyStored(), item.getMaxEnergyStored(this.slots[1]) - item.getEnergyStored(this.slots[1]));
                int r = item.receiveEnergy(this.slots[1], receive, false);
                this.storage.setEnergyStored(this.storage.getEnergyStored() - r);
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Location loc;
                TileEntity entity;
                if (!this.canConnectEnergy(dir) || (entity = (loc = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).add(dir)).getTileEntity()) == null || !(entity instanceof IEnergyReceiver)) continue;
                IEnergyReceiver receiver = (IEnergyReceiver)entity;
                int maxExtract = this.storage.getMaxExtract();
                int maxAvailable = this.storage.extractEnergy(maxExtract, true);
                int energyTransferred = receiver.receiveEnergy(dir.getOpposite(), maxAvailable, false);
                this.storage.extractEnergy(energyTransferred, false);
            }
            this.updateGauge(this.storage.getEnergyStored(), 0, 50);
            this.updateGauge(this.burnTime, 1, 50);
        } else if (this.burnTime > 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
            ForgeDirection dur = dir.getRotation(ForgeDirection.UP);
            double dx = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 0.25 + (double)dur.offsetX * 0.25;
            double dy = (double)this.field_145848_d + 2.0;
            double dz = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 0.25 + (double)dur.offsetZ * 0.25;
            this.field_145850_b.func_72869_a("smoke", dx, dy, dz, 0.0, 0.05, 0.0);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.storage.setEnergyStored(val);
                break;
            }
            case 1: {
                this.burnTime = val;
            }
        }
    }

    public int getPowerScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return i == 0 && TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return this.access;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i != 0) {
            return true;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return this.storage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return this.storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
        this.burnTime = nbt.func_74762_e("burnTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("burnTime", this.burnTime);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

