/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.hfr.tileentity.machine.TileEntityProxyBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityComboProxy
extends TileEntityProxyBase
implements IEnergyHandler,
IFluidHandler {
    public boolean connectEnergy = true;
    public boolean connectFluid = true;

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        if (!this.connectEnergy) {
            return false;
        }
        TileEntity te = this.getTE();
        if (te instanceof IEnergyProvider) {
            return ((IEnergyProvider)te).canConnectEnergy(from);
        }
        if (te instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)te).canConnectEnergy(from);
        }
        return false;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.connectEnergy) {
            return 0;
        }
        TileEntity te = this.getTE();
        if (te instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)te).receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.connectEnergy) {
            return 0;
        }
        TileEntity te = this.getTE();
        if (te instanceof IEnergyProvider) {
            return ((IEnergyProvider)te).extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (!this.connectEnergy) {
            return 0;
        }
        TileEntity te = this.getTE();
        if (te instanceof IEnergyProvider) {
            return ((IEnergyProvider)te).getEnergyStored(from);
        }
        if (te instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)te).getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.connectEnergy) {
            return 0;
        }
        TileEntity te = this.getTE();
        if (te instanceof IEnergyProvider) {
            return ((IEnergyProvider)te).getMaxEnergyStored(from);
        }
        if (te instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)te).getMaxEnergyStored(from);
        }
        return 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.connectFluid) {
            return 0;
        }
        return ((IFluidHandler)this.getTE()).fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.connectFluid) {
            return null;
        }
        return ((IFluidHandler)this.getTE()).drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.connectFluid) {
            return null;
        }
        return ((IFluidHandler)this.getTE()).drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.connectFluid) {
            return false;
        }
        return ((IFluidHandler)this.getTE()).canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.connectFluid) {
            return false;
        }
        return ((IFluidHandler)this.getTE()).canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.connectFluid) {
            return new FluidTankInfo[0];
        }
        return ((IFluidHandler)this.getTE()).getTankInfo(from);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.connectEnergy = nbt.func_74767_n("conEn");
        this.connectFluid = nbt.func_74767_n("conFl");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("conEn", this.connectEnergy);
        nbt.func_74757_a("conFl", this.connectFluid);
    }
}

