/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.hfr.items.ModItems;
import com.hfr.main.MainRegistry;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import com.hfr.util.Location;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDieselGen
extends TileEntityMachineBase
implements IEnergyProvider {
    public EnergyStorage storage = new EnergyStorage(MainRegistry.dieselProduction * 100, MainRegistry.dieselProduction * 10, MainRegistry.dieselProduction * 10);
    public int diesel;
    public static final int maxDiesel = 16000;

    public TileEntityDieselGen() {
        super(3);
    }

    @Override
    public String getName() {
        return "container.dieselGen";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.canister_diesel && this.diesel + 1000 <= 16000) {
                if (this.slots[1] == null) {
                    this.slots[1] = new ItemStack(ModItems.canister_empty);
                    this.func_70298_a(0, 1);
                    this.diesel += 1000;
                } else if (this.slots[1].func_77973_b() == ModItems.canister_empty && this.slots[1].field_77994_a < this.slots[1].func_77976_d()) {
                    ++this.slots[1].field_77994_a;
                    this.func_70298_a(0, 1);
                    this.diesel += 1000;
                }
            }
            if (this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
                for (int i = 0; i < 10; ++i) {
                    if (this.diesel <= 0) continue;
                    --this.diesel;
                    this.storage.receiveEnergy(MainRegistry.dieselProduction / 10, false);
                }
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Location loc;
                TileEntity entity;
                if (!this.canConnectEnergy(dir) || (entity = (loc = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).add(dir)).getTileEntity()) == null || !(entity instanceof IEnergyReceiver)) continue;
                IEnergyReceiver receiver = (IEnergyReceiver)entity;
                int maxExtract = this.storage.getMaxExtract();
                int maxAvailable = this.storage.extractEnergy(maxExtract, true);
                int energyTransferred = receiver.receiveEnergy(dir.getOpposite(), maxAvailable, false);
                this.storage.extractEnergy(energyTransferred, false);
            }
            if (this.slots[2] != null && this.slots[2].func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)this.slots[2].func_77973_b();
                int receive = Math.min(this.storage.getEnergyStored(), item.getMaxEnergyStored(this.slots[2]) - item.getEnergyStored(this.slots[2]));
                int r = item.receiveEnergy(this.slots[2], receive, false);
                this.storage.setEnergyStored(this.storage.getEnergyStored() - r);
            }
            this.updateGauge(this.storage.getEnergyStored(), 0, 50);
            this.updateGauge(this.diesel, 1, 50);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        if (id == 0) {
            this.storage.setEnergyStored(val);
        }
        if (id == 1) {
            this.diesel = val;
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return this.storage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return this.storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
        this.diesel = nbt.func_74762_e("diesel");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("diesel", this.diesel);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

