/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import com.hfr.items.ModItems;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityFoundry
extends TileEntityMachineBase {
    @SideOnly(value=Side.CLIENT)
    public float tilt;
    @SideOnly(value=Side.CLIENT)
    public float lastTilt;
    public float steel;
    public static final float maxSteel = 32.0f;
    public int heat;
    public static final int maxHeat = 4;
    public int smeltTimer;
    public int progress;
    public static final int castTime = 100;
    public int index = 0;
    public static HashMap<String, Float> recipes = new HashMap();
    public static List<Item> options = new ArrayList<Item>();

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.steel = nbt.func_74760_g("steel");
        this.index = nbt.func_74762_e("index");
        this.smeltTimer = nbt.func_74762_e("smeltTimer");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("steel", this.steel);
        nbt.func_74768_a("index", this.index);
        nbt.func_74768_a("smeltTimer", this.smeltTimer);
        nbt.func_74768_a("progress", this.progress);
    }

    public TileEntityFoundry() {
        super(3);
    }

    @Override
    public String getName() {
        return "container.foundry";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            float cost;
            Item target;
            float steelContent;
            if (this.heat == 0 && this.slots[1] != null && this.slots[1].func_77973_b() == Items.field_151044_h) {
                this.func_70298_a(1, 1);
                this.heat = 4;
                this.func_70296_d();
            }
            float f = steelContent = this.slots[0] != null ? this.getSteel(this.slots[0]) : 0.0f;
            if (this.heat > 0 && steelContent > 0.0f && this.steel + steelContent <= 32.0f) {
                ++this.smeltTimer;
                if (this.smeltTimer > 20) {
                    this.smeltTimer = 0;
                    this.steel += steelContent;
                    this.func_70298_a(0, 1);
                    --this.heat;
                    this.func_70296_d();
                }
            } else {
                this.smeltTimer = 0;
            }
            if (this.index < 0) {
                this.index = 0;
            }
            if (this.index >= options.size()) {
                this.index = 0;
            }
            if (this.canProcess(target = options.get(this.index), cost = recipes.get(target.func_77658_a()).floatValue())) {
                ++this.progress;
                if (this.progress >= 100) {
                    this.steel -= cost;
                    this.progress = 0;
                    if (this.slots[2] == null) {
                        this.slots[2] = new ItemStack(target);
                    } else {
                        ++this.slots[2].field_77994_a;
                    }
                    this.func_70296_d();
                }
            } else {
                this.progress = 0;
            }
            this.updateGauge(Math.round(this.steel * 10.0f), 0, 50);
            this.updateGauge(this.heat, 1, 50);
            this.updateGauge(this.progress, 2, 150);
            this.updateGauge(this.index, 3, 50);
        } else {
            this.lastTilt = this.tilt;
            if (this.progress > 0) {
                if (this.tilt < 30.0f) {
                    this.tilt += 1.0f;
                }
            } else if (this.tilt > 0.0f) {
                this.tilt -= 1.0f;
            }
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.steel = (float)val / 10.0f;
                break;
            }
            case 1: {
                this.heat = val;
                break;
            }
            case 2: {
                this.progress = val;
                break;
            }
            case 3: {
                this.index = val;
            }
        }
    }

    private boolean canProcess(Item target, float cost) {
        if (this.steel < cost) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        return this.slots[2].func_77973_b() == target && this.slots[2].field_77994_a < this.slots[2].func_77976_d();
    }

    private float getSteel(ItemStack stack) {
        Float steel;
        if (stack == null) {
            return 0.0f;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ids != null) {
            for (int id : ids) {
                if (!"ingotSteel".equals(OreDictionary.getOreName((int)id))) continue;
                return 1.0f;
            }
        }
        if ((steel = recipes.get(stack.func_77973_b().func_77658_a())) == null) {
            return 0.0f;
        }
        return steel.floatValue();
    }

    public void increment() {
        ++this.index;
        if (this.index >= recipes.size()) {
            this.index = 0;
        }
        this.func_70296_d();
    }

    public void decrement() {
        --this.index;
        if (this.index < 0) {
            this.index = recipes.size() - 1;
        }
        this.func_70296_d();
    }

    public int getSteelScaled(int i) {
        return (int)(this.steel * (float)i / 32.0f);
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 4;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    static {
        recipes.put(ModItems.ingot_steel.func_77658_a(), Float.valueOf(1.0f));
        recipes.put(ModItems.part_spring.func_77658_a(), Float.valueOf(0.5f));
        recipes.put(ModItems.part_rod.func_77658_a(), Float.valueOf(0.5f));
        recipes.put(ModItems.part_rifled_barrel.func_77658_a(), Float.valueOf(2.0f));
        recipes.put(ModItems.part_smoothbore_barrel.func_77658_a(), Float.valueOf(2.0f));
        recipes.put(ModItems.part_gear.func_77658_a(), Float.valueOf(2.5f));
        recipes.put(ModItems.part_plate.func_77658_a(), Float.valueOf(3.0f));
        recipes.put(ModItems.part_frame.func_77658_a(), Float.valueOf(5.0f));
        recipes.put(ModItems.part_grate.func_77658_a(), Float.valueOf(3.0f));
        recipes.put(ModItems.part_suspension.func_77658_a(), Float.valueOf(3.0f));
        recipes.put(ModItems.part_plating_1.func_77658_a(), Float.valueOf(5.0f));
        recipes.put(ModItems.part_hull_1.func_77658_a(), Float.valueOf(15.0f));
        recipes.put(ModItems.part_mechanism_1.func_77658_a(), Float.valueOf(4.0f));
        recipes.put(ModItems.part_steel_wheel.func_77658_a(), Float.valueOf(3.0f));
        recipes.put(ModItems.part_sawblade.func_77658_a(), Float.valueOf(2.5f));
        recipes.put(ModItems.part_track.func_77658_a(), Float.valueOf(2.0f));
        options.add(ModItems.ingot_steel);
        options.add(ModItems.part_spring);
        options.add(ModItems.part_rod);
        options.add(ModItems.part_rifled_barrel);
        options.add(ModItems.part_smoothbore_barrel);
        options.add(ModItems.part_gear);
        options.add(ModItems.part_plate);
        options.add(ModItems.part_frame);
        options.add(ModItems.part_grate);
        options.add(ModItems.part_suspension);
        options.add(ModItems.part_plating_1);
        options.add(ModItems.part_hull_1);
        options.add(ModItems.part_mechanism_1);
        options.add(ModItems.part_steel_wheel);
        options.add(ModItems.part_sawblade);
        options.add(ModItems.part_track);
    }
}

