/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import com.hfr.blocks.BlockSpeedy;
import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.items.ModItems;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineBlastFurnace
extends TileEntityMachineBase {
    public Clowder owner = null;
    public int progress = 0;
    public static final int maxProgress = 600;
    public int fuel = 0;
    public static final int coalValue = 4;
    public static final int maxFuel = 256;
    public float meter;

    public TileEntityMachineBlastFurnace() {
        super(7);
    }

    @Override
    public String getName() {
        return "container.blastFurnace";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            while (this.slots[6] != null && this.slots[6].func_77973_b() == Items.field_151044_h && this.fuel <= 252) {
                this.func_70298_a(6, 1);
                this.fuel += 4;
            }
            while (this.slots[6] != null && this.slots[6].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci) && this.fuel <= 216) {
                this.func_70298_a(6, 1);
                this.fuel += 40;
            }
            if (this.operational()) {
                ClowderTerritory.Ownership o = ClowderTerritory.getOwnerFromInts(this.field_145851_c, this.field_145849_e);
                if (this.owner != o.owner) {
                    if (o != null && o.zone == ClowderTerritory.Zone.FACTION) {
                        if (this.owner != null) {
                            this.owner.addPrestigeGen(-0.1f, this.field_145850_b);
                        }
                        this.owner = o.owner;
                        this.owner.addPrestigeGen(0.1f, this.field_145850_b);
                    } else {
                        if (this.owner != null) {
                            this.owner.addPrestigeGen(-0.1f, this.field_145850_b);
                        }
                        this.owner = null;
                    }
                    this.func_70296_d();
                }
                if (this.hasIron() && this.hasSpace() && this.fuel > 0) {
                    this.progress += 2;
                    if (this.progress >= 600) {
                        this.remIron();
                        this.addSteel();
                        this.progress = 0;
                        --this.fuel;
                        this.func_70296_d();
                    }
                    this.updateGauge(Float.floatToIntBits(this.getMeter()), 2, 250);
                } else {
                    this.progress = 0;
                    this.updateGauge(Float.floatToIntBits(0.0f), 2, 250);
                }
            } else {
                this.progress = 0;
                this.updateGauge(Float.floatToIntBits(0.0f), 2, 250);
            }
            this.updateGauge(this.fuel, 0, 50);
            this.updateGauge(this.progress, 1, 50);
        } else if (this.meter > 0.0f) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            if (dir != ForgeDirection.UNKNOWN) {
                this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 0.75, (double)this.field_145848_d + 0.35, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 0.75, 0.0, 0.0, 0.0);
                this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 0.85, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 0.85, 0.0, 0.0, 0.0);
            }
            float y = 0.5f + this.meter * 4.0f;
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.25, (double)((float)this.field_145848_d + y), (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.25, 0.0, 0.0, 0.0);
        }
        if (this.operational()) {
            float meter = this.getMeter();
            if (this.field_145850_b.field_72995_K) {
                meter = this.meter;
            }
            List mobs = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 0.5 + (double)(meter * 4.0f)), (double)(this.field_145849_e + 1)));
            for (Entity e : mobs) {
                e.func_70110_aj();
                e.func_70015_d(5);
                e.func_70097_a(DamageSource.field_76371_c, 2.0f);
            }
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.fuel = val;
                break;
            }
            case 1: {
                this.progress = val;
                break;
            }
            case 2: {
                this.meter = Float.intBitsToFloat(val);
            }
        }
    }

    public boolean operational() {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d - 1, this.field_145849_e + z) instanceof BlockSpeedy) continue;
                return false;
            }
        }
        return true;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 600;
    }

    public int getFuelScaled(int i) {
        return this.fuel * i / 256;
    }

    public float getMeter() {
        if (this.fuel > 0) {
            float content = 0.0f;
            for (int i = 0; i < 3; ++i) {
                if (this.slots[i] == null || this.slots[i].func_77973_b() != Items.field_151042_j && this.slots[i].func_77973_b() != Item.func_150898_a((Block)Blocks.field_150366_p)) continue;
                content += (float)this.slots[i].field_77994_a;
            }
            return content / 192.0f;
        }
        return 0.0f;
    }

    public boolean hasIron() {
        for (int i = 0; i < 3; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != Items.field_151042_j && this.slots[i].func_77973_b() != Item.func_150898_a((Block)Blocks.field_150366_p)) continue;
            return true;
        }
        return false;
    }

    public void remIron() {
        for (int i = 0; i < 3; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != Items.field_151042_j && this.slots[i].func_77973_b() != Item.func_150898_a((Block)Blocks.field_150366_p)) continue;
            this.func_70298_a(i, 1);
            return;
        }
    }

    public boolean hasSpace() {
        for (int i = 3; i < 6; ++i) {
            if (this.slots[i] != null && (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.ingot_steel || this.slots[i].field_77994_a >= this.slots[i].func_77976_d())) continue;
            return true;
        }
        return false;
    }

    public void addSteel() {
        for (int i = 3; i < 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.ingot_steel && this.slots[i].field_77994_a < this.slots[i].func_77976_d()) {
                ++this.slots[i].field_77994_a;
                return;
            }
            if (this.slots[i] != null) continue;
            this.slots[i] = new ItemStack(ModItems.ingot_steel);
            return;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.owner = Clowder.getClowderFromName("owner");
        this.progress = nbt.func_74762_e("progress");
        this.fuel = nbt.func_74762_e("fuel");
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner != null) {
            nbt.func_74778_a("owner", this.owner.name);
        }
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("fuel", this.fuel);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

