/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import com.hfr.blocks.BlockDummyable;
import com.hfr.blocks.BlockSpeedy;
import com.hfr.handler.MultiblockHandler;
import com.hfr.items.ModItems;
import com.hfr.main.MainRegistry;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCoalMine
extends TileEntityMachineBase {
    public int supplies = 0;
    public static final int maxSupplies = 20;

    public TileEntityMachineCoalMine() {
        super(12);
    }

    @Override
    public String getName() {
        return "container.coalMine";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int workforce;
            boolean dirty = false;
            if (this.slots[5] != null && this.slots[5].func_77973_b() == ModItems.miner_supplies && this.supplies < 20) {
                this.func_70298_a(5, 1);
                ++this.supplies;
                dirty = true;
            }
            if ((workforce = this.getWorkforce()) > 0 && this.operational() && this.hasSpace()) {
                if (this.field_145850_b.field_73012_v.nextInt(MainRegistry.coalJamRate * 20) == 0) {
                    if (this.hasCanary()) {
                        this.func_70298_a(6, 1);
                    } else {
                        this.killMiners();
                        this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1.0f, false, false);
                    }
                    dirty = true;
                } else if (this.field_145850_b.field_73012_v.nextInt(MainRegistry.coalRate * 20 / workforce) == 0) {
                    this.addCoal();
                    if (this.field_145850_b.field_73012_v.nextInt(15) == 0) {
                        --this.supplies;
                    }
                    dirty = true;
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
            this.updateGauge(this.supplies, 0, 50);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        this.supplies = val;
    }

    public int getSuppliesScaled(int i) {
        return this.supplies * i / 20;
    }

    public boolean operational() {
        BlockDummyable dummy = (BlockDummyable)this.func_145838_q();
        int[] dim = MultiblockHandler.rotate(dummy.getDimensions(), ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)));
        int n = dim[2];
        int s = dim[3];
        int w = dim[4];
        int e = dim[5];
        for (int i = -w; i <= e; ++i) {
            for (int j = -n; j <= s; ++j) {
                if ((this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d + 4, this.field_145849_e + j).func_149688_o() == Material.field_151579_a || i == 0 && j == 0) && this.field_145850_b.func_72937_j(this.field_145851_c + i, this.field_145848_d + 4, this.field_145849_e + j)) continue;
                return false;
            }
        }
        for (int x = -w; x <= e; ++x) {
            for (int z = -n; z <= s; ++z) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d - 1, this.field_145849_e + z) instanceof BlockSpeedy) continue;
                return false;
            }
        }
        return true;
    }

    public int getMiners() {
        int count = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.miner) continue;
            ++count;
        }
        return count;
    }

    public void killMiners() {
        for (int i = 0; i < 5; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.miner || this.field_145850_b.field_73012_v.nextInt(4) != 0) continue;
            this.func_70298_a(i, 1);
        }
    }

    public boolean hasSpace() {
        for (int i = 7; i < 12; ++i) {
            if (this.slots[i] == null) {
                return true;
            }
            if (this.slots[i].func_77973_b() != Items.field_151044_h || this.slots[i].field_77994_a >= this.slots[i].func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCanary() {
        return this.slots[6] != null && this.slots[6].func_77973_b() == ModItems.canary;
    }

    public void addCoal() {
        for (int i = 7; i < 12; ++i) {
            if (this.slots[i] == null) {
                this.slots[i] = new ItemStack(Items.field_151044_h);
                return;
            }
            if (this.slots[i].func_77973_b() != Items.field_151044_h || this.slots[i].field_77994_a >= this.slots[i].func_77976_d()) continue;
            ++this.slots[i].field_77994_a;
            return;
        }
    }

    public int getWorkforce() {
        return Math.min(this.supplies, this.getMiners());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.supplies = nbt.func_74762_e("supplies");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("supplies", this.supplies);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

