/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.hfr.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMachineDerrick
extends TileEntity
implements ISidedInventory,
IEnergyHandler {
    private ItemStack[] slots;
    public EnergyStorage storage = new EnergyStorage(MainRegistry.derrickBuffer, MainRegistry.derrickBuffer / 100, MainRegistry.derrickBuffer / 100);
    public int oil;
    public static final int maxOil = 32000;
    public int gas;
    public static final int maxGas = 32000;
    public int warning;
    public int warning2;
    public int age = 0;
    public boolean token = false;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2, 0};
    private static final int[] slots_side = new int[]{0};
    Random rand = new Random();
    private String customName;
    int steps = 0;
    List<int[]> list = new ArrayList<int[]>();

    public TileEntityMachineDerrick() {
        this.slots = new ItemStack[5];
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.oilWell";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.storage.readFromNBT(nbt);
        this.age = nbt.func_74762_e("age");
        this.oil = nbt.func_74762_e("oil");
        this.gas = nbt.func_74762_e("gas");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("age", this.age);
        nbt.func_74768_a("oil", this.oil);
        nbt.func_74768_a("gas", this.gas);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public long getPowerScaled(long i) {
        return (long)this.storage.getEnergyStored() * i / (long)this.storage.getMaxEnergyStored();
    }

    public long getOilScaled(int i) {
        return this.oil * i / 32000;
    }

    public long getGasScaled(int i) {
        return this.gas * i / 32000;
    }

    public void func_145845_h() {
        int timer = MainRegistry.derrickTimer;
        ++this.age;
        if (this.age >= timer) {
            this.age = 0;
        }
    }

    public boolean isOre(Block b, int meta) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(b, 1, meta));
        for (int i = 0; i < ids.length; ++i) {
            String s = OreDictionary.getOreName((int)ids[i]);
            if (s.length() <= 3 || !s.substring(0, 3).equals("ore")) continue;
            return true;
        }
        return false;
    }

    public boolean succ(int x, int y, int z) {
        this.list.clear();
        this.steps = 0;
        this.succ1(x, y, z);
        this.steps = 0;
        this.succ2(x, y, z);
        if (!this.list.isEmpty()) {
            int i = this.rand.nextInt(this.list.size());
            int a = this.list.get(i)[0];
            int b = this.list.get(i)[1];
            int n = this.list.get(i)[2];
        }
        return false;
    }

    public void succInit1(int x, int y, int z) {
        ArrayList indices = new ArrayList(){
            {
                this.add(0);
                this.add(1);
                this.add(2);
                this.add(3);
                this.add(4);
                this.add(5);
            }
        };
        Collections.shuffle(indices);
        for (Integer i : indices) {
            switch (i) {
                case 0: {
                    this.succ1(x + 1, y, z);
                    break;
                }
                case 1: {
                    this.succ1(x - 1, y, z);
                    break;
                }
                case 2: {
                    this.succ1(x, y + 1, z);
                    break;
                }
                case 3: {
                    this.succ1(x, y - 1, z);
                    break;
                }
                case 4: {
                    this.succ1(x, y, z + 1);
                    break;
                }
                case 5: {
                    this.succ1(x, y, z - 1);
                }
            }
        }
    }

    public void succInit2(int x, int y, int z) {
        ArrayList indices = new ArrayList(){
            {
                this.add(0);
                this.add(1);
                this.add(2);
                this.add(3);
                this.add(4);
                this.add(5);
            }
        };
        Collections.shuffle(indices);
        for (Integer i : indices) {
            switch (i) {
                case 0: {
                    this.succ2(x + 1, y, z);
                    break;
                }
                case 1: {
                    this.succ2(x - 1, y, z);
                    break;
                }
                case 2: {
                    this.succ2(x, y + 1, z);
                    break;
                }
                case 3: {
                    this.succ2(x, y - 1, z);
                    break;
                }
                case 4: {
                    this.succ2(x, y, z + 1);
                    break;
                }
                case 5: {
                    this.succ2(x, y, z - 1);
                }
            }
        }
    }

    public void succ1(int x, int y, int z) {
        ++this.steps;
        if (this.steps > MainRegistry.derrickLimiter) {
            return;
        }
    }

    public void succ2(int x, int y, int z) {
        ++this.steps;
        if (this.steps > MainRegistry.derrickLimiter) {
            return;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        double toSend = Math.min(this.storage.getEnergyStored(), this.storage.getMaxExtract());
        if (!simulate) {
            this.storage.setEnergyStored(this.storage.getEnergyStored() - (int)Math.round(toSend));
        }
        return (int)Math.round(toSend);
    }
}

