/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import com.hfr.items.ModItems;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineEFurnace
extends TileEntityMachineBase
implements IEnergyHandler {
    public EnergyStorage storage = new EnergyStorage(10000, 1000, 1000);
    public int progress;
    public static final int processingSpeed = 100;

    public TileEntityMachineEFurnace() {
        super(7);
    }

    @Override
    public String getName() {
        return "container.machineEFurnace";
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public long getPowerRemainingScaled(long i) {
        return (long)this.storage.getEnergyStored() * i / (long)this.storage.getMaxEnergyStored();
    }

    public boolean hasPower() {
        return this.storage.getEnergyStored() >= 500;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    public boolean canProcess() {
        if (this.slots[1] == null) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[1]);
        if (itemStack == null) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        if (!this.slots[2].func_77969_a(itemStack)) {
            return false;
        }
        if (this.slots[2].field_77994_a < this.func_70297_j_() && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) {
            return true;
        }
        return this.slots[2].field_77994_a < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[1]);
            if (this.slots[2] == null) {
                this.slots[2] = itemStack.func_77946_l();
            } else if (this.slots[2].func_77969_a(itemStack)) {
                this.slots[2].field_77994_a += itemStack.field_77994_a;
            }
            for (int i = 1; i < 2; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.battery) {
                this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
            }
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)this.slots[0].func_77973_b();
                int extract = Math.min(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), item.getEnergyStored(this.slots[0]));
                int e = item.extractEnergy(this.slots[0], extract, false);
                this.storage.setEnergyStored(this.storage.getEnergyStored() + e);
            }
            if (this.hasPower() && this.canProcess()) {
                ++this.progress;
                this.storage.setEnergyStored(this.storage.getEnergyStored() - 500);
                if (this.progress == 100) {
                    this.progress = 0;
                    this.processItem();
                    this.func_70296_d();
                }
            } else {
                this.progress = 0;
            }
            this.updateGauge(this.progress, 0, 50);
            this.updateGauge(this.storage.getEnergyStored(), 1, 50);
        } else if (this.progress > 0) {
            Vec3 vec = Vec3.func_72443_a((double)-0.75, (double)1.3, (double)0.25);
            switch (this.func_145832_p() - 10) {
                case 2: {
                    vec.func_72442_b((float)Math.toRadians(0.0));
                    break;
                }
                case 4: {
                    vec.func_72442_b((float)Math.toRadians(90.0));
                    break;
                }
                case 3: {
                    vec.func_72442_b((float)Math.toRadians(180.0));
                    break;
                }
                case 5: {
                    vec.func_72442_b((float)Math.toRadians(270.0));
                }
            }
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + vec.field_72450_a, (double)this.field_145848_d + 0.5 + vec.field_72448_b, (double)this.field_145849_e + 0.5 + vec.field_72449_c, 0.0, 0.0, 0.0);
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + vec.field_72450_a, (double)this.field_145848_d + 0.5 + vec.field_72448_b, (double)this.field_145849_e + 0.5 + vec.field_72449_c, 0.0, 0.05, 0.0);
            this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + vec.field_72450_a, (double)this.field_145848_d + 0.5 + vec.field_72448_b, (double)this.field_145849_e + 0.5 + vec.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        if (id == 0) {
            this.progress = val;
        }
        if (id == 1) {
            this.storage.setEnergyStored(val);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        this.storage.writeToNBT(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

