/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import com.hfr.entity.IEmpable;
import com.hfr.items.ModItems;
import com.hfr.packet.PacketDispatcher;
import com.hfr.packet.tile.AuxElectricityPacket;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineEMP
extends TileEntityMachineBase
implements IEnergyHandler {
    public int range = 100;
    public static final int maxRange = 500;
    public boolean isOn;
    public EnergyStorage storage = new EnergyStorage(100000000, 5000000, 5000000);

    public TileEntityMachineEMP() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.machineEMP";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.range < 10) {
                this.range = 10;
            }
            if (this.range > 500) {
                this.range = 500;
            }
            if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.battery) {
                this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
            }
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)this.slots[0].func_77973_b();
                int extract = Math.min(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), item.getEnergyStored(this.slots[0]));
                int e = item.extractEnergy(this.slots[0], extract, false);
                this.storage.setEnergyStored(this.storage.getEnergyStored() + e);
            }
            if (this.isOn) {
                int required = this.range * this.range * 20;
                if (this.storage.getEnergyStored() >= required) {
                    this.storage.setEnergyStored(this.storage.getEnergyStored() - required);
                    List entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.range), (double)0.0, (double)(this.field_145849_e - this.range), (double)(this.field_145851_c + this.range), (double)10000.0, (double)(this.field_145849_e + this.range)));
                    for (Entity e : entities) {
                        Vec3 vec = Vec3.func_72443_a((double)(e.field_70165_t - (double)this.field_145851_c), (double)0.0, (double)(e.field_70161_v - (double)this.field_145849_e));
                        if (!(vec.func_72433_c() <= (double)this.range) || !(e instanceof IEmpable)) continue;
                        ((IEmpable)e).pulse();
                    }
                } else {
                    this.isOn = false;
                }
            }
            this.updateGauge(this.isOn ? 1 : 0, 0, 50);
            this.updateGauge(this.range, 1, 50);
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.storage.getEnergyStored()));
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.isOn = val == 1;
                break;
            }
            case 1: {
                this.range = val;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.range = nbt.func_74762_e("range");
        this.isOn = nbt.func_74767_n("isOn");
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("range", this.range);
        nbt.func_74757_a("isOn", this.isOn);
        this.storage.writeToNBT(nbt);
    }

    public int getPowerScaled(int i) {
        long buf = this.storage.getEnergyStored();
        return (int)((buf *= (long)i) / (long)this.storage.getMaxEnergyStored());
    }

    public int getRangeScaled(int i) {
        return this.range * i / 500;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        double toSend = Math.min(this.storage.getEnergyStored(), this.storage.getMaxExtract());
        if (!simulate) {
            this.storage.setEnergyStored(this.storage.getEnergyStored() - (int)Math.round(toSend));
        }
        return (int)Math.round(toSend);
    }
}

