/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import com.hfr.blocks.BlockSpeedy;
import com.hfr.items.ModItems;
import com.hfr.main.MainRegistry;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineFactory
extends TileEntityMachineBase
implements IEnergyReceiver {
    public EnergyStorage storage = new EnergyStorage(MainRegistry.factoryConsumption * 100, MainRegistry.factoryConsumption * 10, MainRegistry.factoryConsumption * 10);
    private static final int[] access = new int[]{0, 1, 2, 3, 4};

    public TileEntityMachineFactory() {
        super(6);
    }

    @Override
    public String getName() {
        return "container.machineFactory";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.operational() && this.hasSpace() && this.slots[4] == null) {
                int i;
                this.storage.setEnergyStored(this.storage.getEnergyStored() - MainRegistry.factoryConsumption);
                if (this.field_145850_b.field_73012_v.nextInt(MainRegistry.factoryRate * 20) == 0) {
                    for (i = 0; i < 4; ++i) {
                        if (this.slots[i] == null) {
                            this.slots[i] = new ItemStack(ModItems.cog);
                            break;
                        }
                        if (this.slots[i].func_77973_b() != ModItems.cog || this.slots[i].field_77994_a >= this.slots[i].func_77976_d()) continue;
                        ++this.slots[i].field_77994_a;
                        break;
                    }
                }
                if (this.field_145850_b.field_73012_v.nextInt(MainRegistry.factoryJamRate * 20) == 0) {
                    i = this.field_145850_b.field_73012_v.nextInt(10);
                    this.slots[4] = i < 5 ? new ItemStack(Items.field_151121_aF).func_151001_c("Worker Strike") : (i < 7 ? new ItemStack(Items.field_151144_bL).func_151001_c("Workplace Accident") : (i < 9 ? new ItemStack(Items.field_151123_aH).func_151001_c("Chemical Spill") : new ItemStack(Items.field_151174_bG).func_151001_c("Communist Takeover")));
                }
            }
            this.updateGauge(this.storage.getEnergyStored(), 0, 50);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        this.storage.setEnergyStored(val);
    }

    public boolean operational() {
        for (int i = -4; i <= 4; ++i) {
            for (int j = -4; j <= 4; ++j) {
                if ((this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d + 4, this.field_145849_e + j).func_149688_o() == Material.field_151579_a || i == 0 && j == 0) && this.field_145850_b.func_72937_j(this.field_145851_c + i, this.field_145848_d + 4, this.field_145849_e + j)) continue;
                return false;
            }
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d - 1, this.field_145849_e + z) instanceof BlockSpeedy) continue;
                return false;
            }
        }
        if (this.storage.getEnergyStored() < MainRegistry.factoryConsumption) {
            return false;
        }
        return this.slots[4] == null;
    }

    public boolean hasSpace() {
        for (int i = 0; i < 4; ++i) {
            if (this.slots[i] != null && (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.cog || this.slots[i].field_77994_a >= this.slots[i].func_77976_d())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return access;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.DOWN && from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int getPowerScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }
}

