/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.hfr.entity.missile.EntityMissileAntiBallistic;
import com.hfr.entity.missile.EntityMissileBaseAdvanced;
import com.hfr.entity.missile.EntityMissileBaseSimple;
import com.hfr.entity.projectile.EntityRailgunBlast;
import com.hfr.entity.projectile.EntityShell;
import com.hfr.main.MainRegistry;
import com.hfr.packet.PacketDispatcher;
import com.hfr.packet.tile.AuxElectricityPacket;
import com.hfr.packet.tile.TESRadarPacket;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineRadar
extends TileEntity
implements IEnergyHandler {
    public List<RadarEntry> nearbyMissiles = new ArrayList<RadarEntry>();
    int pingTimer = 0;
    static final int maxTimer = 40;
    public int mode = 0;
    int scanTimer = 0;
    int maxScan = 5;
    public EnergyStorage storage = new EnergyStorage(MainRegistry.coalgenProduction * 1200, MainRegistry.coalgenProduction * 10, MainRegistry.coalgenProduction * 10);

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
        this.mode = nbt.func_74762_e("mode");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("mode", this.mode);
    }

    public void func_145845_h() {
        if (this.field_145848_d < MainRegistry.radarAltitude) {
            return;
        }
        if (this.storage.getEnergyStored() > 0) {
            if (!this.field_145850_b.field_72995_K) {
                ++this.scanTimer;
                if (this.scanTimer == this.maxScan) {
                    this.scanTimer = 0;
                    this.allocateMissiles();
                    this.sendMissileData();
                }
            }
            this.storage.setEnergyStored(this.storage.getEnergyStored() - MainRegistry.radarConsumption);
            if (this.storage.getEnergyStored() < 0) {
                this.storage.setEnergyStored(0);
            }
        } else if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAll((IMessage)new TESRadarPacket(null, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.mode));
        }
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.storage.getEnergyStored()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 25.0));
        }
        ++this.pingTimer;
        if (this.storage.getEnergyStored() > 0 && this.pingTimer >= 40 && MainRegistry.sound) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hfr:block.sonarPing", 2.0f, 1.0f);
            this.pingTimer = 0;
        }
    }

    private void allocateMissiles() {
        this.nearbyMissiles.clear();
        List list = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - (double)MainRegistry.radarRange), (double)0.0, (double)((double)this.field_145849_e + 0.5 - (double)MainRegistry.radarRange), (double)((double)this.field_145851_c + 0.5 + (double)MainRegistry.radarRange), (double)5000.0, (double)((double)this.field_145849_e + 0.5 + (double)MainRegistry.radarRange)));
        for (Entity e : list) {
            if (!(e.field_70163_u >= (double)(this.field_145848_d + MainRegistry.radarBuffer))) continue;
            if ((this.mode == 0 || this.mode == 2) && e instanceof EntityPlayer) {
                this.nearbyMissiles.add(new RadarEntry((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, ((EntityPlayer)e).getDisplayName()));
            }
            if (this.mode == 0 || this.mode == 1) {
                if (e instanceof EntityMissileBaseAdvanced) {
                    this.nearbyMissiles.add(new RadarEntry((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, "Tier " + (((EntityMissileBaseAdvanced)e).getMissileType() + 1) + " Missile"));
                } else if (e instanceof EntityMissileBaseSimple && ((EntityMissileBaseSimple)e).mode != 2) {
                    this.nearbyMissiles.add(new RadarEntry((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, "Tier " + (((EntityMissileBaseSimple)e).getMissileType() + 1) + " Missile (Ascending)"));
                } else if (e instanceof EntityMissileBaseSimple) {
                    this.nearbyMissiles.add(new RadarEntry((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, "Tier " + (((EntityMissileBaseSimple)e).getMissileType() + 1) + " Missile"));
                } else if (e instanceof EntityMissileAntiBallistic) {
                    this.nearbyMissiles.add(new RadarEntry((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, "Anti-Ballistic Missile"));
                }
            }
            if (this.mode != 0 && this.mode != 3) continue;
            if (e instanceof EntityShell) {
                this.nearbyMissiles.add(new RadarEntry((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, "Shell"));
                continue;
            }
            if (!(e instanceof EntityRailgunBlast)) continue;
            this.nearbyMissiles.add(new RadarEntry((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, "Railgun Charge"));
        }
    }

    public int getRedPower() {
        if (!this.nearbyMissiles.isEmpty()) {
            double maxRange = (double)MainRegistry.radarRange * Math.sqrt(2.0);
            int power = 0;
            for (int i = 0; i < this.nearbyMissiles.size(); ++i) {
                double dist;
                int p;
                RadarEntry j = this.nearbyMissiles.get(i);
                if (j.name.equals("Anti-Ballistic Missile") || j.name.endsWith("(Ascending)") || (p = 15 - (int)Math.floor((dist = Math.sqrt(Math.pow(j.posX - this.field_145851_c, 2.0) + Math.pow(j.posZ - this.field_145849_e, 2.0))) / maxRange * 15.0)) <= power) continue;
                power = p;
            }
            return power;
        }
        return 0;
    }

    private void sendMissileData() {
        PacketDispatcher.wrapper.sendToAll((IMessage)new TESRadarPacket(this.nearbyMissiles.toArray(new RadarEntry[0]), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.mode));
    }

    public long getPowerScaled(long i) {
        return (long)this.storage.getEnergyStored() * i / (long)this.storage.getMaxEnergyStored();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        double toSend = Math.min(this.storage.getEnergyStored(), this.storage.getMaxExtract());
        if (!simulate) {
            this.storage.setEnergyStored(this.storage.getEnergyStored() - (int)Math.round(toSend));
        }
        return (int)Math.round(toSend);
    }

    public static class RadarEntry {
        public int posX;
        public int posY;
        public int posZ;
        public String name;

        public RadarEntry(int x, int y, int z, String s) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.name = s;
        }
    }
}

