/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import com.hfr.items.ModItems;
import com.hfr.main.MainRegistry;
import com.hfr.packet.PacketDispatcher;
import com.hfr.packet.tile.AuxElectricityPacket;
import com.hfr.packet.tile.AuxGaugePacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineRefinery
extends TileEntity
implements ISidedInventory,
IEnergyHandler {
    private ItemStack[] slots;
    public EnergyStorage storage = new EnergyStorage(MainRegistry.refineryBuffer, MainRegistry.refineryBuffer / 100, MainRegistry.refineryBuffer / 100);
    public int oil;
    public static final int maxOil = 64000;
    public int heavy;
    public static final int maxHeavy = 16000;
    public int naph;
    public static final int maxNaph = 16000;
    public int light;
    public static final int maxLight = 16000;
    public int petro;
    public static final int maxPetro = 16000;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{0, 2, 4, 6, 8, 10, 11};
    private static final int[] slots_side = new int[]{0, 3, 5, 7, 9};
    private String customName;

    public TileEntityMachineRefinery() {
        this.slots = new ItemStack[11];
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machineRefinery";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        this.storage.readFromNBT(nbt);
        this.oil = nbt.func_74762_e("oil");
        this.heavy = nbt.func_74762_e("heavy");
        this.naph = nbt.func_74762_e("naph");
        this.light = nbt.func_74762_e("light");
        this.petro = nbt.func_74762_e("petro");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("oil", this.oil);
        nbt.func_74768_a("heavy", this.heavy);
        nbt.func_74768_a("naph", this.naph);
        nbt.func_74768_a("light", this.light);
        nbt.func_74768_a("petro", this.petro);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.battery) {
                this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
            }
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)this.slots[0].func_77973_b();
                int extract = Math.min(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), item.getEnergyStored(this.slots[0]));
                int e = item.extractEnergy(this.slots[0], extract, false);
                this.storage.setEnergyStored(this.storage.getEnergyStored() + extract);
            }
            if (this.slots[3] != null && this.slots[3].func_77973_b() == ModItems.canister_empty && this.heavy >= 1000) {
                if (this.slots[4] != null && this.slots[4].func_77973_b() == ModItems.canister_petroil && this.slots[4].field_77994_a < this.slots[4].func_77976_d()) {
                    this.func_70298_a(3, 1);
                    ++this.slots[4].field_77994_a;
                    this.heavy -= 1000;
                } else if (this.slots[4] == null) {
                    this.func_70298_a(3, 1);
                    this.slots[4] = new ItemStack(ModItems.canister_petroil);
                    this.heavy -= 1000;
                }
            }
            if (this.slots[5] != null && this.slots[5].func_77973_b() == ModItems.canister_empty && this.naph >= 1000) {
                if (this.slots[6] != null && this.slots[6].func_77973_b() == ModItems.canister_diesel && this.slots[6].field_77994_a < this.slots[6].func_77976_d()) {
                    this.func_70298_a(5, 1);
                    ++this.slots[6].field_77994_a;
                    this.naph -= 1000;
                } else if (this.slots[6] == null) {
                    this.func_70298_a(5, 1);
                    this.slots[6] = new ItemStack(ModItems.canister_diesel);
                    this.naph -= 1000;
                }
            }
            if (this.slots[7] != null && this.slots[7].func_77973_b() == ModItems.canister_empty && this.light >= 1000) {
                if (this.slots[8] != null && this.slots[8].func_77973_b() == ModItems.canister_kerosene && this.slots[8].field_77994_a < this.slots[8].func_77976_d()) {
                    this.func_70298_a(7, 1);
                    ++this.slots[8].field_77994_a;
                    this.light -= 1000;
                } else if (this.slots[8] == null) {
                    this.func_70298_a(7, 1);
                    this.slots[8] = new ItemStack(ModItems.canister_kerosene);
                    this.light -= 1000;
                }
            }
            if (this.slots[9] != null && this.slots[9].func_77973_b() == ModItems.gas_empty && this.petro >= 1000) {
                if (this.slots[10] != null && this.slots[10].func_77973_b() == ModItems.gas_petroleum && this.slots[10].field_77994_a < this.slots[10].func_77976_d()) {
                    this.func_70298_a(9, 1);
                    ++this.slots[10].field_77994_a;
                    this.petro -= 1000;
                } else if (this.slots[10] == null) {
                    this.func_70298_a(9, 1);
                    this.slots[10] = new ItemStack(ModItems.gas_petroleum);
                    this.petro -= 1000;
                }
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.canister_oil && this.oil <= 63000) {
                if (this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.canister_empty && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) {
                    this.func_70298_a(1, 1);
                    ++this.slots[2].field_77994_a;
                    this.oil += 1000;
                } else if (this.slots[2] == null) {
                    this.func_70298_a(1, 1);
                    this.slots[2] = new ItemStack(ModItems.canister_empty);
                    this.oil += 1000;
                }
            }
            int ho = MainRegistry.refHeavy;
            int nt = MainRegistry.refNaph;
            int lo = MainRegistry.refLight;
            int pe = MainRegistry.refPetro;
            if (this.storage.getEnergyStored() >= MainRegistry.refineryUse && this.oil >= MainRegistry.refOil && this.heavy + ho <= 16000 && this.naph + nt <= 16000 && this.light + lo <= 16000 && this.petro + pe <= 16000) {
                this.oil -= MainRegistry.refOil;
                this.heavy += ho;
                this.naph += nt;
                this.light += lo;
                this.petro += pe;
                this.storage.setEnergyStored(this.storage.getEnergyStored() - MainRegistry.refineryUse);
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.storage.getEnergyStored()));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.oil, 0));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.heavy, 1));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.naph, 2));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.light, 3));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.petro, 4));
        }
    }

    public long getPowerScaled(long i) {
        return (long)this.storage.getEnergyStored() * i / (long)this.storage.getMaxEnergyStored();
    }

    public long getOilScaled(long i) {
        return (long)this.oil * i / 64000L;
    }

    public long getHeavyScaled(long i) {
        return (long)this.heavy * i / 16000L;
    }

    public long getNaphScaled(long i) {
        return (long)this.naph * i / 16000L;
    }

    public long getLightScaled(long i) {
        return (long)this.light * i / 16000L;
    }

    public long getPetroScaled(long i) {
        return (long)this.petro * i / 16000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        double toSend = Math.min(this.storage.getEnergyStored(), this.storage.getMaxExtract());
        if (!simulate) {
            this.storage.setEnergyStored(this.storage.getEnergyStored() - (int)Math.round(toSend));
        }
        return (int)Math.round(toSend);
    }
}

