/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import com.hfr.items.ModItems;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineSawmill
extends TileEntityMachineBase
implements IEnergyHandler {
    public int progress = 0;
    public static final int maxProgress = 100;
    public EnergyStorage storage = new EnergyStorage(10000, 1000, 1000);

    public TileEntityMachineSawmill() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.machineSawmill";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack recipe;
            if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.battery) {
                this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)this.slots[1].func_77973_b();
                int extract = Math.min(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), item.getEnergyStored(this.slots[1]));
                int e = item.extractEnergy(this.slots[1], extract, false);
                this.storage.setEnergyStored(this.storage.getEnergyStored() + e);
            }
            if ((recipe = TileEntityMachineSawmill.getRecipe(this.slots[0])) != null && this.hasSpace(recipe) && this.storage.getEnergyStored() >= 50) {
                ++this.progress;
                if (this.progress >= 100) {
                    this.process(recipe);
                    this.func_70298_a(0, 1);
                    this.progress = 0;
                    this.func_70296_d();
                }
                this.storage.setEnergyStored(this.storage.getEnergyStored() - 50);
            } else {
                this.progress = 0;
            }
            this.updateGauge(this.storage.getEnergyStored(), 0, 50);
            this.updateGauge(this.progress, 1, 50);
        } else if (this.progress > 0) {
            Vec3 vec = Vec3.func_72443_a((double)-1.0, (double)0.875, (double)-0.5);
            switch (this.func_145832_p() - 10) {
                case 2: {
                    vec.func_72442_b((float)Math.toRadians(0.0));
                    break;
                }
                case 4: {
                    vec.func_72442_b((float)Math.toRadians(90.0));
                    break;
                }
                case 3: {
                    vec.func_72442_b((float)Math.toRadians(180.0));
                    break;
                }
                case 5: {
                    vec.func_72442_b((float)Math.toRadians(270.0));
                }
            }
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + vec.field_72450_a, (double)this.field_145848_d + 0.5 + vec.field_72448_b, (double)this.field_145849_e + 0.5 + vec.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.storage.setEnergyStored(val);
                break;
            }
            case 1: {
                this.progress = val;
            }
        }
    }

    private void process(ItemStack output) {
        if (this.slots[2] == null) {
            this.slots[2] = output.func_77946_l();
        } else {
            this.slots[2].field_77994_a += output.field_77994_a;
        }
        if (this.slots[3] == null) {
            this.slots[3] = new ItemStack(ModItems.part_sawdust);
        } else if (this.slots[3].field_77994_a < this.slots[3].func_77976_d()) {
            ++this.slots[3].field_77994_a;
        }
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            if (this.slots[4] == null) {
                this.slots[4] = new ItemStack(ModItems.part_rubber_drop);
            } else if (this.slots[4].field_77994_a < this.slots[4].func_77976_d()) {
                ++this.slots[4].field_77994_a;
            }
        }
    }

    public boolean hasSpace(ItemStack output) {
        if (this.slots[2] == null) {
            return true;
        }
        return this.slots[2].func_77973_b() == output.func_77973_b() && this.slots[2].func_77960_j() == output.func_77960_j() && this.slots[2].field_77994_a + output.field_77994_a <= this.slots[2].func_77976_d();
    }

    public static ItemStack getRecipe(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150364_r)) {
            return new ItemStack(Blocks.field_150344_f, 6, stack.func_77960_j());
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150363_s)) {
            return new ItemStack(Blocks.field_150344_f, 6, stack.func_77960_j() + 4);
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f)) {
            return new ItemStack(Items.field_151055_y, 6);
        }
        return null;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public int getPowerScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        this.storage.writeToNBT(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

