/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import com.hfr.handler.FluidHandler;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityMachineTurbine
extends TileEntityMachineBase
implements IEnergyProvider,
IFluidHandler {
    public EnergyStorage storage = new EnergyStorage(100000000, 100000, 100000);
    public int mode = 1;
    public FluidTank water;
    public FluidTank steam = new FluidTank(FluidHandler.STEAM, 0, 128000);

    public TileEntityMachineTurbine() {
        super(1);
        this.water = new FluidTank(FluidRegistry.WATER, 0, 128000);
    }

    @Override
    public String getName() {
        return "container.machineTurbine";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int process = Math.min(this.steam.getFluidAmount(), 500);
            if (this.mode == 1) {
                process = Math.min(process, this.water.getCapacity() - this.water.getFluidAmount());
            }
            if (process > 0) {
                this.steam.getFluid().amount -= process;
                if (this.mode != 0) {
                    this.water.getFluid().amount += process;
                }
                this.func_70296_d();
            }
            if (this.mode == 0) {
                this.water.getFluid().amount = 0;
            }
            this.updateGauge(this.water.getFluidAmount(), 0, 25);
            this.updateGauge(this.steam.getFluidAmount(), 1, 25);
            this.updateGauge(this.storage.getEnergyStored(), 2, 25);
            this.updateGauge(this.mode, 3, 25);
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.water.getFluid().amount = val;
                break;
            }
            case 1: {
                this.steam.getFluid().amount = val;
                break;
            }
            case 2: {
                this.storage.setEnergyStored(val);
                break;
            }
            case 3: {
                this.mode = val;
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.DOWN && from != ForgeDirection.UNKNOWN;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            int fill = Math.min(this.steam.getCapacity() - this.steam.getFluidAmount(), resource.amount);
            if (fill <= 0) {
                return 0;
            }
            FluidStack sauce = resource.copy();
            sauce.amount = fill;
            this.func_70296_d();
            return this.steam.fill(sauce, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.canDrain(from, resource.getFluid()) && this.water.getFluidAmount() > 0) {
            this.func_70296_d();
            FluidStack drain = this.water.drain(Math.min(this.water.getFluidAmount(), resource.amount), doDrain);
            if (this.water.getFluid() == null) {
                this.water.setFluid(new FluidStack(FluidRegistry.WATER, 0));
            }
            return drain;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.water.getFluidAmount() > 0) {
            this.func_70296_d();
            FluidStack drain = this.water.drain(Math.min(this.water.getFluidAmount(), maxDrain), doDrain);
            if (this.water.getFluid() == null) {
                this.water.setFluid(new FluidStack(FluidRegistry.WATER, 0));
            }
            return drain;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidHandler.STEAM && this.steam.getFluidAmount() < this.steam.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && this.water.getFluidAmount() > 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.steam), new FluidTankInfo((IFluidTank)this.water)};
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water.readFromNBT(nbt);
        this.steam.readFromNBT(nbt);
        if (this.water.getFluid() == null) {
            this.water.setFluid(new FluidStack(FluidRegistry.WATER, 0));
        }
        if (this.steam.getFluid() == null) {
            this.steam.setFluid(new FluidStack(FluidHandler.STEAM, 0));
        }
        this.mode = nbt.func_74762_e("mode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.water.writeToNBT(nbt);
        this.steam.writeToNBT(nbt);
        nbt.func_74768_a("mode", this.mode);
    }

    public int getPowerScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    public int getWaterScaled(int i) {
        return this.water.getFluidAmount() * i / this.water.getCapacity();
    }

    public int getSteamScaled(int i) {
        return this.steam.getFluidAmount() * i / this.steam.getCapacity();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

