/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.hfr.blocks.BlockSpeedy;
import com.hfr.main.MainRegistry;
import com.hfr.util.Location;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineWindmill
extends TileEntity
implements IEnergyProvider {
    public EnergyStorage storage = new EnergyStorage(MainRegistry.windmillProduction * 10, MainRegistry.windmillProduction, MainRegistry.windmillProduction);
    @SideOnly(value=Side.CLIENT)
    public float rotation;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.operational()) {
            this.storage.receiveEnergy(MainRegistry.windmillProduction, false);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Location loc;
                TileEntity entity;
                if (!this.canConnectEnergy(dir) || (entity = (loc = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).add(dir).add(dir)).getTileEntity()) == null || !(entity instanceof IEnergyReceiver)) continue;
                IEnergyReceiver receiver = (IEnergyReceiver)entity;
                int maxExtract = this.storage.getMaxExtract();
                int maxAvailable = this.storage.extractEnergy(maxExtract, true);
                int energyTransferred = receiver.receiveEnergy(dir.getOpposite(), maxAvailable, false);
                this.storage.extractEnergy(energyTransferred, false);
            }
        }
    }

    public boolean operational() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if ((this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d + 32, this.field_145849_e + j).func_149688_o() == Material.field_151579_a || i == 0 && j == 0) && this.field_145850_b.func_72937_j(this.field_145851_c + i, this.field_145848_d + 32, this.field_145849_e + j)) continue;
                return false;
            }
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d - 1, this.field_145849_e + z) instanceof BlockSpeedy) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.DOWN && from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return this.storage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return this.storage.getMaxEnergyStored();
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

