/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import com.hfr.handler.FluidHandler;
import com.hfr.items.ItemFuel;
import com.hfr.items.ModItems;
import com.hfr.tileentity.machine.TileEntityMachineBase;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityRBMKElement
extends TileEntityMachineBase
implements IFluidHandler {
    public float reactivity;
    public static final float maxReactivity = 400.0f;
    public FluidTank water = new FluidTank(FluidRegistry.WATER, 4000, 8000);
    public FluidTank steam = new FluidTank(FluidHandler.STEAM, 4000, 8000);

    public TileEntityRBMKElement() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.rbmkElement";
    }

    @Override
    public void func_145845_h() {
        this.updateGauge((int)this.reactivity, 0, 15);
        this.updateGauge(this.water.getFluidAmount(), 1, 15);
        this.updateGauge(this.steam.getFluidAmount(), 2, 15);
        if (!this.field_145850_b.field_72995_K) {
            this.process();
        }
    }

    @Override
    public void processGauge(int val, int id) {
        switch (id) {
            case 0: {
                this.reactivity = val;
                break;
            }
            case 1: {
                this.water.getFluid().amount = val;
                break;
            }
            case 2: {
                this.steam.getFluid().amount = val;
            }
        }
    }

    public void process() {
        float reactivity = this.calculateReactivity();
        this.generateXenon(this.getPoisonRate());
        this.burnXenon(this.getXenonBurnup());
        this.irradiate(ForgeDirection.NORTH, reactivity);
        this.irradiate(ForgeDirection.SOUTH, reactivity);
        this.irradiate(ForgeDirection.EAST, reactivity);
        this.irradiate(ForgeDirection.WEST, reactivity);
        int conv = 100;
        int defacto = Math.min(this.steam.getCapacity() - this.steam.getFluidAmount(), this.water.getFluidAmount());
        defacto = (int)Math.min((float)defacto, reactivity * (float)conv / 400.0f);
        if (defacto > 0) {
            this.steam.getFluid().amount += defacto;
            this.water.getFluid().amount -= defacto;
            this.func_70296_d();
        }
        this.reactivity = 0.0f;
    }

    public void irradiate(ForgeDirection dir, float reactivity) {
        float origin;
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        float adjusted = origin = reactivity;
        for (int i = 0; i < 3; ++i) {
            Block block = this.field_145850_b.func_147439_a(x += dir.offsetX, this.field_145848_d, z += dir.offsetZ);
        }
    }

    public void generateXenon(float xenon) {
        for (int i = 0; i < 4; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.uranium_fuel) continue;
            float poison = ItemFuel.getPoison(this.slots[i]) + xenon;
            if (poison > 100.0f) {
                poison = 100.0f;
            }
            ItemFuel.setPoison(this.slots[i], poison);
        }
    }

    public void burnXenon(float xenon) {
        for (int i = 0; i < 4; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.uranium_fuel) continue;
            float poison = ItemFuel.getPoison(this.slots[i]) - xenon;
            if (poison < 0.0f) {
                poison = 0.0f;
            }
            ItemFuel.setPoison(this.slots[i], poison);
        }
    }

    public float getPoisonRate() {
        float x = this.getEnrichtment() * (this.reactivity / 400.0f);
        return x / 800.0f;
    }

    public float getXenonBurnup() {
        float x = this.getEnrichtment() * (this.reactivity / 400.0f);
        return (float)(Math.pow(x, 2.0) / 10000.0);
    }

    public float calculateReactivity() {
        float neutrons = 0.0f;
        if (this.reactivity < 25.0f) {
            neutrons = this.getEnrichtmentFlat() / 100.0f * ((100.0f - this.getXenonPoison()) / 100.0f) * 5.0f;
        } else {
            neutrons = this.getEnrichtmentFlat() / 100.0f * ((100.0f - this.getXenonPoison()) / 100.0f) * (this.reactivity * 70.0f / 400.0f);
            if (neutrons > 0.0f) {
                neutrons += 5.0f;
            }
        }
        return neutrons;
    }

    public float getEnrichtment() {
        float cap = 400.0f;
        float enrichment = 0.0f;
        for (int i = 0; i < 4; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.uranium_fuel) continue;
            enrichment += (float)ItemFuel.getDura(this.slots[i]) * 100.0f / 7.2E7f;
        }
        return enrichment * 100.0f / cap;
    }

    public float getEnrichtmentFlat() {
        float enrichment = 0.0f;
        for (int i = 0; i < 4; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.uranium_fuel) continue;
            enrichment += 25.0f;
        }
        return enrichment;
    }

    public float getXenonPoison() {
        float cap = 0.0f;
        float poison = 0.0f;
        for (int i = 0; i < 4; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.uranium_fuel) continue;
            cap += 100.0f;
            poison += ItemFuel.getPoison(this.slots[i]);
        }
        if (cap == 0.0f) {
            return 0.0f;
        }
        return poison * 100.0f / cap;
    }

    public int getXenonScaled(int i) {
        return (int)(this.getXenonPoison() * (float)i / 100.0f);
    }

    public int getReactivityScaled(int i) {
        return (int)(this.reactivity * (float)i / 400.0f);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.reactivity = nbt.func_74760_g("reactivity");
        this.water.readFromNBT(nbt);
        this.steam.readFromNBT(nbt);
        if (this.water.getFluid() == null) {
            this.water.setFluid(new FluidStack(FluidRegistry.WATER, 0));
        }
        if (this.steam.getFluid() == null) {
            this.steam.setFluid(new FluidStack(FluidHandler.STEAM, 0));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("reactivity", this.reactivity);
        this.water.writeToNBT(nbt);
        this.steam.writeToNBT(nbt);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            int cap = 8000 - this.water.getFluidAmount() - this.steam.getFluidAmount();
            int fill = Math.min(cap, resource.amount);
            if (fill <= 0) {
                return 0;
            }
            FluidStack sauce = resource.copy();
            sauce.amount = fill;
            this.func_70296_d();
            return this.water.fill(sauce, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.canDrain(from, resource.getFluid()) && this.steam.getFluidAmount() > 0) {
            this.func_70296_d();
            FluidStack drain = this.steam.drain(Math.min(this.steam.getFluidAmount(), resource.amount), doDrain);
            if (this.steam.getFluid() == null) {
                this.steam.setFluid(new FluidStack(FluidHandler.STEAM, 0));
            }
            return drain;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.steam.getFluidAmount() > 0) {
            this.func_70296_d();
            FluidStack drain = this.steam.drain(Math.min(this.steam.getFluidAmount(), maxDrain), doDrain);
            if (this.steam.getFluid() == null) {
                this.steam.setFluid(new FluidStack(FluidHandler.STEAM, 0));
            }
            return drain;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && this.water.getFluidAmount() < this.water.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == FluidHandler.STEAM && this.steam.getFluidAmount() > 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.water), new FluidTankInfo((IFluidTank)this.steam)};
    }
}

