/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.hfr.main.MainRegistry;
import com.hfr.util.Location;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWaterWheel
extends TileEntity
implements IEnergyProvider {
    public EnergyStorage storage = new EnergyStorage(MainRegistry.waterwheelProduction * 10, MainRegistry.waterwheelProduction, MainRegistry.waterwheelProduction);
    @SideOnly(value=Side.CLIENT)
    public float rotation;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.operational()) {
            this.storage.receiveEnergy(MainRegistry.waterwheelProduction, false);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Location loc;
                TileEntity entity;
                if (!this.canConnectEnergy(dir) || (entity = (loc = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).add(dir)).getTileEntity()) == null || !(entity instanceof IEnergyReceiver)) continue;
                IEnergyReceiver receiver = (IEnergyReceiver)entity;
                int maxExtract = this.storage.getMaxExtract();
                int maxAvailable = this.storage.extractEnergy(maxExtract, true);
                int energyTransferred = receiver.receiveEnergy(dir.getOpposite(), maxAvailable, false);
                this.storage.extractEnergy(energyTransferred, false);
            }
        }
    }

    public boolean operational() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p()).getRotation(ForgeDirection.UP);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (!this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX * j, this.field_145848_d + i, this.field_145849_e + dir.offsetZ * j).func_149721_r()) continue;
                return false;
            }
        }
        if (this.hasWater(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            return true;
        }
        if (this.hasWater(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e)) {
            return true;
        }
        if (this.hasWater(this.field_145851_c + dir.offsetX, this.field_145848_d - 1, this.field_145849_e + dir.offsetZ)) {
            return true;
        }
        if (this.hasWater(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ)) {
            return true;
        }
        if (this.hasWater(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2)) {
            return true;
        }
        return this.hasWater(this.field_145851_c + dir.offsetX, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ);
    }

    public boolean hasWater(int x, int y, int z) {
        return (this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150355_j || this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150358_i) && this.field_145850_b.func_72805_g(x, y, z) > 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP && from != ForgeDirection.DOWN && from != ForgeDirection.UNKNOWN;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return this.storage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return this.storage.getMaxEnergyStored();
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

