/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.util;

import com.hfr.main.ReflectionEngine;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S13PacketDestroyEntities;
import net.minecraft.network.play.server.S1BPacketEntityAttach;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LoggingEngine {
    private static final List<String> log = new ArrayList<String>();
    private static final int interval = 10000;

    public static void log(String message) {
        log.add(System.currentTimeMillis() + ":" + message);
    }

    public static void flush() {
        long now = System.currentTimeMillis();
        for (String mesg : log) {
            String timestamp = mesg.split(":")[0];
            String tmp = "undefined";
            long longTime = Long.parseLong(timestamp);
            if (longTime + 10000L < now) continue;
            Date date = new Date(longTime);
            String millis = longTime % 1000L + "";
            while (millis.length() < 3) {
                millis = "0" + millis;
            }
            tmp = String.format("[%s:%s:%s.%s]", date.getHours(), date.getMinutes(), date.getSeconds(), millis);
            String message = mesg.replace(timestamp + ":", tmp + " ");
            System.out.println(message);
        }
        log.clear();
    }

    public static void survey() {
        boolean i000 = false;
        if (!i000) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            LoggingEngine.log("Player is NULL. Skipping...");
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            LoggingEngine.log("WorldOBJ is NULL. Skipping...");
            return;
        }
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        double lastX = player.field_70142_S;
        double lastY = player.field_70137_T;
        double lastZ = player.field_70136_U;
        double prevX = player.field_70169_q;
        double prevY = player.field_70167_r;
        double prevZ = player.field_70166_s;
        double servX = player.field_70118_ct;
        double servY = player.field_70117_cu;
        double servZ = player.field_70116_cv;
        double moX = player.field_70159_w;
        double moY = player.field_70181_x;
        double moZ = player.field_70179_y;
        Entity ridden = player.field_70154_o;
        LoggingEngine.log("========== Starting profiler for entity tick " + player.func_70654_ax() + " ==========");
        LoggingEngine.log("[Player] Logging position for entity");
        LoggingEngine.log(String.format("[Player] X: %s / %s / %s / %s", x, lastX, prevX, servX));
        LoggingEngine.log(String.format("[Player] Y: %s / %s / %s / %s", y, lastY, prevY, servY));
        LoggingEngine.log(String.format("[Player] Z: %s / %s / %s / %s", z, lastZ, prevZ, servZ));
        LoggingEngine.log("[Player] Logging motion for entity");
        LoggingEngine.log(String.format("[Player] X: %s", moX));
        LoggingEngine.log(String.format("[Player] Y: %s", moY));
        LoggingEngine.log(String.format("[Player] Z: %s", moZ));
        LoggingEngine.log("[Ridden] Logging ridden entity data");
        if (ridden == null) {
            LoggingEngine.log("[Ridden] Ridden entity is NULL. Skipping!");
        } else {
            double ridden_x = ridden.field_70165_t;
            double ridden_y = ridden.field_70163_u;
            double ridden_z = ridden.field_70161_v;
            double ridden_lastX = ridden.field_70142_S;
            double ridden_lastY = ridden.field_70137_T;
            double ridden_lastZ = ridden.field_70136_U;
            double ridden_prevX = ridden.field_70169_q;
            double ridden_prevY = ridden.field_70167_r;
            double ridden_prevZ = ridden.field_70166_s;
            double ridden_servX = ridden.field_70118_ct;
            double ridden_servY = ridden.field_70117_cu;
            double ridden_servZ = ridden.field_70116_cv;
            double ridden_moX = ridden.field_70159_w;
            double ridden_moY = ridden.field_70181_x;
            double ridden_moZ = ridden.field_70179_y;
            String name = ridden.func_70005_c_();
            String className = ridden.getClass().getSimpleName();
            int riddenID = ridden.func_145782_y();
            LoggingEngine.log("[Ridden] Logging general data for ridden entity");
            LoggingEngine.log("[Ridden] Entity name: " + name);
            LoggingEngine.log("[Ridden] Instance class name: " + className);
            LoggingEngine.log("[Ridden] Ridden ID: " + riddenID);
            LoggingEngine.log("[Ridden] Logging position for ridden entity");
            LoggingEngine.log(String.format("[Ridden] X: %s / %s / %s / %s", ridden_x, ridden_lastX, ridden_prevX, ridden_servX));
            LoggingEngine.log(String.format("[Ridden] Y: %s / %s / %s / %s", ridden_y, ridden_lastY, ridden_prevY, ridden_servY));
            LoggingEngine.log(String.format("[Ridden] Z: %s / %s / %s / %s", ridden_z, ridden_lastZ, ridden_prevZ, ridden_servZ));
            LoggingEngine.log("[Ridden] Logging motion for ridden entity");
            LoggingEngine.log(String.format("[Ridden] X: %s", ridden_moX));
            LoggingEngine.log(String.format("[Ridden] Y: %s", ridden_moY));
            LoggingEngine.log(String.format("[Ridden] Z: %s", ridden_moZ));
        }
        List proximity = world.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - 20.0), (double)(player.field_70163_u - 20.0), (double)(player.field_70161_v - 20.0), (double)(player.field_70165_t + 20.0), (double)(player.field_70163_u + 20.0), (double)(player.field_70161_v + 20.0)));
        for (Entity proxmox : proximity) {
            double proximity_x = proxmox.field_70165_t;
            double proximity_y = proxmox.field_70163_u;
            double proximity_z = proxmox.field_70161_v;
            double proximity_moX = proxmox.field_70159_w;
            double proximity_moY = proxmox.field_70181_x;
            double proximity_moZ = proxmox.field_70179_y;
            String proximity_name = proxmox.func_70005_c_();
            String proximity_className = proxmox.getClass().getSimpleName();
            int proximity_ID = proxmox.func_145782_y();
            LoggingEngine.log("[Proximity] Logging entity within proximity");
            LoggingEngine.log(String.format("[Proximity] ID: %s, Name: %s, Class: %s", proximity_ID, proximity_name, proximity_className));
            LoggingEngine.log(String.format("[Proximity] Position: %s / %s / %s", proximity_x, proximity_y, proximity_z));
            LoggingEngine.log(String.format("[Proximity] Motion: %s / %s / %s", proximity_moX, proximity_moY, proximity_moZ));
        }
        LoggingEngine.log("========== Ending profiler for entity tick " + player.func_70654_ax() + " ==========");
        LoggingEngine.log("========== Starting profiler for packets tick " + player.func_70654_ax() + " ==========");
        NetworkManager netman = Minecraft.func_71410_x().func_147114_u().func_147298_b();
        Queue inboundpackets = ReflectionEngine.hasValue(netman, Queue.class, "receivedPacketsQueue", null);
        if (inboundpackets == null) {
            inboundpackets = ReflectionEngine.hasValue(netman, Queue.class, "field_150748_i", null);
        }
        if (inboundpackets == null) {
            LoggingEngine.log("[Packets Inbound] CRITICAL ERROR: INBOUND MESSAGE QUEUE NOT REFLECTED.");
        } else {
            for (Object o : inboundpackets) {
                if (o instanceof FMLProxyPacket) continue;
                LoggingEngine.log("[Packets Inbound] Detected packet" + o.getClass().getSimpleName());
                if (o instanceof S13PacketDestroyEntities) {
                    S13PacketDestroyEntities satan = (S13PacketDestroyEntities)o;
                    int[] hitlist = satan.func_149098_c();
                    for (int i = 0; i < hitlist.length; ++i) {
                        int jfk = hitlist[i];
                        Entity deadman = world.func_73045_a(jfk);
                        String name = deadman == null ? "NULL" : deadman.getClass().getSimpleName();
                        LoggingEngine.log("[Satan Packet] Found index " + jfk + " which belongs to a " + deadman);
                        if (ridden == null || ridden.func_145782_y() != jfk) continue;
                        LoggingEngine.log("[Satan Packet] [[[ HIT DETECTED! ]]]");
                    }
                }
                if (!(o instanceof S1BPacketEntityAttach)) continue;
                S1BPacketEntityAttach baphomet = (S1BPacketEntityAttach)o;
                int dat = baphomet.func_149404_c();
                int ent1 = baphomet.func_149403_d();
                int ent2 = baphomet.func_149402_e();
                Entity victim1 = world.func_73045_a(ent1);
                Entity victim2 = world.func_73045_a(ent2);
                String dead1 = victim1 == null ? "NULL" : victim1.getClass().getSimpleName();
                String dead2 = victim2 == null ? "NULL" : victim2.getClass().getSimpleName();
                LoggingEngine.log("[Baphomet Packet] Attempted to mount index " + ent1 + " belonging to " + dead1 + " to index " + ent2 + " belonging to " + dead2);
                if (ridden == null || ridden.func_145782_y() != ent1 && ridden.func_145782_y() != ent2) continue;
                LoggingEngine.log("[Baphomet Packet] [[[ HIT DETECTED! ]]]");
            }
        }
        LoggingEngine.log("========== Ending profiler for packets tick " + player.func_70654_ax() + " ==========");
    }
}

