/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.util;

import com.hfr.tileentity.machine.TileEntityDuct;
import com.hfr.tileentity.machine.TileEntityMachineDerrick;
import com.hfr.tileentity.machine.TileEntityMachineRefinery;
import com.hfr.tileentity.machine.TileEntityTank;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PipeUtil {
    private static Set<TileEntityDuct> tiles = new HashSet<TileEntityDuct>();

    private static void distributeOil(TileEntityMachineDerrick source, World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityMachineRefinery) {
            TileEntityMachineRefinery ref = (TileEntityMachineRefinery)te;
            int fill = Math.min(64000 - ref.oil, source.oil);
            source.oil -= fill;
            ref.oil += fill;
        } else if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.fill == 0 || tank.type == 0) {
                int fill = Math.min(2000000 - tank.fill, source.oil);
                source.oil -= fill;
                tank.fill += fill;
                tank.type = 0;
            }
        }
    }

    public static void initOil(TileEntityMachineDerrick source, World world, int x, int y, int z) {
        PipeUtil.distributeOil(source, world, x + 1, y, z);
        PipeUtil.distributeOil(source, world, x - 1, y, z);
        PipeUtil.distributeOil(source, world, x, y, z + 1);
        PipeUtil.distributeOil(source, world, x, y, z - 1);
        tiles.clear();
    }

    private static void distributeGas(TileEntityMachineDerrick source, World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.fill == 0 || tank.type == 1) {
                int fill = Math.min(2000000 - tank.fill, source.gas);
                source.gas -= fill;
                tank.fill += fill;
                tank.type = 1;
            }
        }
    }

    public static void initGas(TileEntityMachineDerrick source, World world, int x, int y, int z) {
        PipeUtil.distributeGas(source, world, x + 1, y, z);
        PipeUtil.distributeGas(source, world, x - 1, y, z);
        PipeUtil.distributeGas(source, world, x, y, z + 1);
        PipeUtil.distributeGas(source, world, x, y, z - 1);
        tiles.clear();
    }
}

